/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.BasicDatagramConnection;
import javax.microedition.io.BasicInputConnection;
import javax.microedition.io.BasicOutputConnection;
import javax.microedition.io.BasicStreamConnection;
import javax.microedition.io.Connection;
import javax.microedition.io.FileStreamCreator;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.SocketStreamCreator;
import javax.microedition.io.StreamCreator;
import javax.microedition.io.URLStreamCreator;

public class Connector {
    public static final int READ = 1;
    public static final int READ_WRITE = 3;
    public static final int WRITE = 2;

    public static Connection open(String name) throws IOException {
        return Connector.open(name, 3, false);
    }

    public static Connection open(String name, int mode) throws IOException {
        return Connector.open(name, mode, false);
    }

    public static Connection open(String name, int mode, boolean times_out) throws IOException {
        StreamCreator creator2;
        int index = name.indexOf(58);
        if (index == -1) {
            throw new IllegalArgumentException("no valid connection specified '" + name + '\'');
        }
        if (mode < 0 || mode > 3) {
            throw new IllegalArgumentException("invalid mode specified " + mode);
        }
        String protocol = name.substring(0, index);
        if (protocol.equals("serversocket")) {
            return new ServerSocketConnection(name.substring(index + 1), times_out);
        }
        if (protocol.equals("datagram")) {
            return new BasicDatagramConnection(name.substring(index + 1), times_out);
        }
        if (protocol.equals("file")) {
            String string = name.substring(index + 1);
            boolean bl = false;
            if (mode == 1) {
                bl = true;
            }
            creator2 = new FileStreamCreator(string, bl);
        } else if (protocol.equals("socket")) {
            creator2 = new SocketStreamCreator(name.substring(index + 1), times_out);
        } else {
            if (mode != 3) {
                throw new IllegalArgumentException("invalid mode specified " + mode + " for ContentConnections");
            }
            URLStreamCreator creator2 = new URLStreamCreator(name);
            return new BasicStreamConnection(creator2);
        }
        switch (mode) {
            case 3: {
                return new BasicStreamConnection(creator2);
            }
            case 1: {
                return new BasicInputConnection(creator2);
            }
            case 2: {
                return new BasicOutputConnection(creator2);
            }
        }
        throw new IllegalArgumentException("invalid mode specified");
    }

    public static DataInputStream openDataInputStream(String name) throws IOException {
        return ((InputConnection)Connector.open(name, 1, false)).openDataInputStream();
    }

    public static DataOutputStream openDataOutputStream(String name) throws IOException {
        return ((OutputConnection)Connector.open(name, 2, false)).openDataOutputStream();
    }

    public static InputStream openInputStream(String name) throws IOException {
        return ((InputConnection)Connector.open(name, 1, false)).openInputStream();
    }

    public static OutputStream openOutputStream(String name) throws IOException {
        return ((OutputConnection)Connector.open(name, 2, false)).openOutputStream();
    }

    private Connector() {
    }
}

