/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ZipOutputStream
extends DeflaterOutputStream
implements ZipConstants {
    public static final int DEFLATED = 8;
    public static final int STORED = 0;
    private boolean finished;
    private int level;
    private int method;
    private ByteArrayOutputStream centralDirRecord;
    private String comment;
    private long byteCount;
    private int NrOfEntries;
    private byte[] timeBytes;
    private boolean entryOpen;
    private byte[] currentFileHeader;
    private ZipEntry currentEntry;
    private boolean preset;
    private boolean deflating;
    private long dataCount;
    private LinkedList names;
    private CRC32 crc;

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    public void finish() throws IOException {
        if (!this.finished) {
            if (this.entryOpen) {
                this.closeEntry();
            }
            this.out.write(this.centralDirRecord.toByteArray());
            byte[] endCD = (byte[])EndOfCDRecord.clone();
            endCD[8] = (byte)this.NrOfEntries;
            endCD[9] = (byte)(this.NrOfEntries >>> 8);
            endCD[10] = endCD[8];
            endCD[11] = endCD[9];
            this.putBytes(this.centralDirRecord.size(), 12, endCD);
            this.putBytes((int)this.byteCount, 16, endCD);
            if (this.comment != null) {
                int l = this.comment.length();
                endCD[20] = (byte)l;
                endCD[21] = (byte)(l >>> 8);
                this.out.write(endCD, 0, 22);
                this.out.write(this.comment.getBytes());
            } else {
                this.out.write(endCD, 0, 22);
            }
            this.finished = true;
        }
    }

    public void closeEntry() throws IOException {
        String com;
        if (this.finished) {
            throw new IOException();
        }
        if (this.deflating) {
            this.def.finish();
            this.deflate();
        }
        if (!this.preset) {
            byte[] trailer = new byte[16];
            System.arraycopy(dataDescS, 0, trailer, 0, 4);
            int bytes = (int)this.crc.getValue();
            this.currentEntry.setCrc(this.crc.getValue());
            this.putBytes(bytes, 4, trailer);
            this.putBytes(bytes, 16, this.currentFileHeader);
            bytes = this.def.getTotalOut();
            this.currentEntry.setCompressedSize(bytes);
            this.putBytes(bytes, 8, trailer);
            this.putBytes(bytes, 20, this.currentFileHeader);
            bytes = this.def.getTotalIn();
            this.currentEntry.setSize(bytes);
            this.putBytes(bytes, 12, trailer);
            this.putBytes(bytes, 24, this.currentFileHeader);
            this.out.write(trailer, 0, 16);
        } else if (this.deflating ? this.currentEntry.getCrc() != this.crc.getValue() || (int)this.currentEntry.getSize() != this.def.getTotalIn() || (int)this.currentEntry.getCompressedSize() != this.def.getTotalOut() : this.currentEntry.getCrc() != this.crc.getValue() || (long)((int)this.currentEntry.getSize()) != this.dataCount || (long)((int)this.currentEntry.getCompressedSize()) != this.dataCount) {
            throw new ZipException();
        }
        byte[] extra = this.currentEntry.getExtra();
        if (extra != null) {
            int i = extra.length;
            this.currentFileHeader[30] = (byte)i;
            this.currentFileHeader[31] = (byte)(i >>> 8);
        }
        if ((com = this.currentEntry.getComment()) != null) {
            int i = com.length();
            this.currentFileHeader[32] = (byte)i;
            this.currentFileHeader[33] = (byte)(i >>> 8);
        }
        this.centralDirRecord.write(this.currentFileHeader, 0, 46);
        this.centralDirRecord.write(this.currentEntry.getName().getBytes());
        if (extra != null) {
            this.centralDirRecord.write(extra);
        }
        if (com != null) {
            this.centralDirRecord.write(com.getBytes());
        }
        this.byteCount += (long)(this.preset ? 0 : 16) + this.currentEntry.getCompressedSize();
        this.entryOpen = false;
        this.def.reset();
    }

    public void putNextEntry(ZipEntry ze) throws IOException {
        String s;
        if (this.finished) {
            throw new IOException();
        }
        if (this.entryOpen) {
            this.closeEntry();
        }
        if (this.names.contains(s = ze.getName())) {
            throw new ZipException("stream already contains " + s);
        }
        this.names.addLast(s);
        this.currentEntry = ze;
        byte[] header = new byte[30];
        this.currentFileHeader = (byte[])fileHeader.clone();
        System.arraycopy(locFileHeaderS, 0, header, 0, 4);
        header[4] = 20;
        header[5] = 0;
        int i = ze.getMethod();
        i = i == -1 ? this.method : i;
        header[8] = (byte)i;
        this.currentFileHeader[10] = (byte)i;
        this.def.setLevel(this.level);
        if (i == 8) {
            this.deflating = true;
        } else {
            this.deflating = false;
            this.dataCount = 0L;
        }
        if (ze.getTime() == (long)-1) {
            System.arraycopy(this.timeBytes, 0, header, 10, 4);
            System.arraycopy(this.timeBytes, 0, this.currentFileHeader, 12, 4);
        } else {
            this.longToDosTime(ze.getTime(), header, 10);
            System.arraycopy(header, 10, this.currentFileHeader, 12, 4);
        }
        if (ze.getCrc() == (long)-1 || ze.getSize() == (long)-1 || ze.getCompressedSize() == (long)-1) {
            if (!this.deflating) {
                throw new ZipException("CRC, size and compressed size should be set when storing");
            }
            this.preset = false;
            header[6] = 8;
            this.currentFileHeader[8] = 8;
        } else {
            int bytes = (int)ze.getCrc();
            this.putBytes(bytes, 14, header);
            this.putBytes(bytes, 16, this.currentFileHeader);
            bytes = (int)ze.getCompressedSize();
            this.putBytes(bytes, 18, header);
            this.putBytes(bytes, 20, this.currentFileHeader);
            bytes = (int)ze.getSize();
            this.putBytes(bytes, 22, header);
            this.putBytes(bytes, 24, this.currentFileHeader);
            this.preset = true;
        }
        this.putBytes((int)this.byteCount, 42, this.currentFileHeader);
        i = s.length();
        this.byteCount += (long)(i + 30);
        header[26] = (byte)i;
        this.currentFileHeader[28] = (byte)i;
        header[27] = (byte)(i >>>= 8);
        this.currentFileHeader[29] = (byte)i;
        byte[] extra = ze.getExtra();
        if (extra != null) {
            i = extra.length;
            this.byteCount += (long)i;
            header[28] = (byte)i;
            header[29] = (byte)(i >>> 8);
        }
        this.out.write(header, 0, 30);
        this.out.write(s.getBytes());
        if (extra != null) {
            this.out.write(extra, 0, i);
        }
        this.crc.reset();
        ++this.NrOfEntries;
        this.entryOpen = true;
    }

    public void setComment(String comment) {
        if (comment.length() > (char)-1) {
            throw new IllegalArgumentException();
        }
        this.comment = comment;
    }

    public void setLevel(int lvl) {
    }

    public void setMethod(int m) {
        if (m != 8 && m != 0) {
            throw new IllegalArgumentException();
        }
        this.method = m;
    }

    public void write(byte[] buf, int offset, int len) throws IOException {
        if (this.finished) {
            throw new IOException();
        }
        this.crc.update(buf, offset, len);
        if (this.deflating) {
            super.write(buf, offset, len);
        } else {
            this.out.write(buf, offset, len);
            this.dataCount += (long)len;
        }
    }

    private final void putBytes(int bytes, int off, byte[] buf) {
        buf[off++] = (byte)bytes;
        buf[off++] = (byte)(bytes >>> 8);
        buf[off++] = (byte)(bytes >>> 16);
        buf[off] = (byte)(bytes >>> 24);
    }

    private final void longToDosTime(long time, byte[] bytes, int offset) {
        GregorianCalendar gc = new GregorianCalendar(0, 0, 0);
        gc.setTime(new Date(time));
        int value = gc.get(11) << 11;
        value |= (gc.get(12) & 0x3F) << 5;
        bytes[offset] = (byte)(value |= gc.get(13) / 2 & 0x1F);
        bytes[offset + 1] = (byte)(value >>> 8);
        value = gc.get(1) - 1980 << 9;
        value |= (gc.get(2) + 1 & 0xF) << 5;
        bytes[offset + 2] = (byte)(value |= gc.get(5) & 0x1F);
        bytes[offset + 3] = (byte)(value >>> 8);
    }

    private final /* synthetic */ void this() {
        this.finished = false;
        this.level = 8;
        this.method = 8;
        this.centralDirRecord = new ByteArrayOutputStream();
        this.comment = null;
        this.byteCount = 0L;
        this.NrOfEntries = 0;
        this.entryOpen = false;
        this.currentFileHeader = null;
        this.currentEntry = null;
        this.names = new LinkedList();
        this.crc = new CRC32();
    }

    public ZipOutputStream(OutputStream out) {
        super(out, new Deflater(8, true));
        this.this();
        this.timeBytes = new byte[4];
        this.longToDosTime(System.currentTimeMillis(), this.timeBytes, 0);
    }
}

