/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GZIPOutputStream
extends DeflaterOutputStream {
    private static final byte[] GZIPHeader;
    protected CRC32 crc;
    private boolean finished;

    public void close() throws IOException {
        this.finish();
        super.close();
    }

    public void finish() throws IOException {
        if (!this.finished) {
            super.finish();
            byte[] trailer = new byte[8];
            int i = 0;
            int bytes = (int)this.crc.getValue();
            trailer[i++] = (byte)bytes;
            trailer[i++] = (byte)(bytes >>>= 8);
            trailer[i++] = (byte)(bytes >>>= 8);
            trailer[i++] = (byte)(bytes >>>= 8);
            bytes = this.def.getTotalIn();
            trailer[i++] = (byte)bytes;
            trailer[i++] = (byte)(bytes >>>= 8);
            trailer[i++] = (byte)(bytes >>>= 8);
            trailer[i++] = (byte)(bytes >>>= 8);
            this.out.write(trailer, 0, 8);
            this.finished = true;
        }
    }

    public void write(byte[] buf, int offset, int len) throws IOException {
        if (this.finished) {
            throw new IOException("stream has finished");
        }
        this.crc.update(buf, offset, len);
        super.write(buf, offset, len);
    }

    private final /* synthetic */ void this() {
        this.crc = new CRC32();
        this.finished = false;
    }

    public GZIPOutputStream(OutputStream outst) throws IOException {
        super(outst, new Deflater(8, true));
        this.this();
        this.out.write(GZIPHeader, 0, GZIPHeader.length);
    }

    public GZIPOutputStream(OutputStream outst, int readsize) throws IOException {
        super(outst, new Deflater(8, true), readsize);
        this.this();
        this.out.write(GZIPHeader, 0, GZIPHeader.length);
    }

    static {
        byte[] byArray = new byte[10];
        byArray[0] = 31;
        byArray[1] = -117;
        byArray[2] = 8;
        GZIPHeader = byArray;
    }
}

