/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Checksum;

public class CheckedOutputStream
extends FilterOutputStream {
    private Checksum checksum;

    public Checksum getChecksum() {
        return this.checksum;
    }

    public void write(int bval) throws IOException {
        this.out.write(bval);
        this.checksum.update(bval);
    }

    public void write(byte[] buf, int offset, int len) throws IOException {
        this.out.write(buf, offset, len);
        this.checksum.update(buf, offset, len);
    }

    public CheckedOutputStream(OutputStream out, Checksum cs) {
        super(out);
        if (cs == null) {
            throw new NullPointerException();
        }
        this.checksum = cs;
    }
}

