/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;

public class TreeSet
extends AbstractSet
implements SortedSet,
Cloneable,
Serializable {
    private static final Object value = new Object();
    private transient TreeMap backMap;
    private static final long serialVersionUID = -2479143000061671589L;

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.backMap = new TreeMap((Comparator)s.readObject());
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            this.add(s.readObject());
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.backMap.comparator());
        int size = this.backMap.size();
        s.writeInt(size);
        Iterator it = this.iterator();
        for (int i = 0; i < size; ++i) {
            s.writeObject(it.next());
        }
    }

    public TreeSet() {
        this.backMap = new TreeMap();
    }

    public TreeSet(Collection c) {
        this.backMap = new TreeMap();
        this.addAll(c);
    }

    public TreeSet(SortedSet s) {
        this.backMap = new TreeMap(s.comparator());
        this.addAll(s);
    }

    public TreeSet(Comparator comp) {
        this.backMap = new TreeMap(comp);
    }

    public boolean add(Object key) {
        return this.backMap.put(key, value) == null;
    }

    public boolean remove(Object key) {
        boolean ans = this.backMap.containsKey(key);
        this.backMap.remove(key);
        return ans;
    }

    public boolean contains(Object key) {
        return this.backMap.containsKey(key);
    }

    public void clear() {
        this.backMap.clear();
    }

    public Object clone() {
        TreeSet ts = null;
        try {
            ts = (TreeSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        ts.backMap = (TreeMap)this.backMap.clone();
        return ts;
    }

    public Comparator comparator() {
        return this.backMap.comparator();
    }

    public Object first() {
        return this.backMap.firstKey();
    }

    public Object last() {
        return this.backMap.lastKey();
    }

    public boolean isEmpty() {
        return this.backMap.isEmpty();
    }

    public int size() {
        return this.backMap.size();
    }

    public Iterator iterator() {
        return this.backMap.keySet().iterator();
    }

    public SortedSet headSet(Object toV) {
        return new SubTreeSet(toV, false, (SortedMap)this.backMap);
    }

    public SortedSet tailSet(Object fromV) {
        return new SubTreeSet(fromV, true, (SortedMap)this.backMap);
    }

    public SortedSet subSet(Object fromV, Object toV) {
        return new SubTreeSet(fromV, toV, (SortedMap)this.backMap);
    }

    private static class SubTreeSet
    extends AbstractSet
    implements SortedSet {
        private SortedMap back;

        public SubTreeSet(Object o, boolean tail, SortedMap m) {
            this.back = tail ? m.tailMap(o) : m.headMap(o);
        }

        public SubTreeSet(Object from, Object to, SortedMap m) {
            this.back = m.subMap(from, to);
        }

        public int size() {
            return this.back.size();
        }

        public boolean add(Object key) {
            return this.back.put(key, value) == null;
        }

        public Iterator iterator() {
            return this.back.keySet().iterator();
        }

        public Object first() {
            return this.back.firstKey();
        }

        public Object last() {
            return this.back.lastKey();
        }

        public Comparator comparator() {
            return this.back.comparator();
        }

        public SortedSet headSet(Object toV) {
            return new SubTreeSet(toV, false, this.back);
        }

        public SortedSet tailSet(Object fromV) {
            return new SubTreeSet(fromV, true, this.back);
        }

        public SortedSet subSet(Object fromV, Object toV) {
            return new SubTreeSet(fromV, toV, this.back);
        }
    }
}

