/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringTokenizer
implements Enumeration {
    private String base;
    private String delimeted;
    private int delimeter;
    private boolean delimTokens;
    private int index = 0;

    public StringTokenizer(String str) {
        this(str, " \t\n\r", false);
    }

    public StringTokenizer(String str, String delim) {
        this(str, delim, false);
    }

    public StringTokenizer(String str, String delim, boolean returnTokens) {
        this.base = str;
        this.delimTokens = returnTokens;
        this.setDelimeters(delim);
    }

    public int countTokens() {
        int delimeted_length = this.delimeted.length();
        if (this.index >= delimeted_length) {
            return 0;
        }
        if (this.delimeter == -1) {
            return 1;
        }
        int count = 0;
        if (this.delimTokens) {
            int prev = this.index - 1;
            int pos = this.delimeted.indexOf(this.delimeter, this.index);
            while (pos != -1) {
                ++count;
                if (pos - prev > 1) {
                    ++count;
                }
                prev = pos;
                pos = this.delimeted.indexOf(this.delimeter, pos + 1);
            }
            if (prev < delimeted_length - 1 & (prev != this.index - 1 | count == 0)) {
                ++count;
            }
        } else {
            int pos = this.delimeted.indexOf(this.delimeter, this.index);
            int prev = this.index - 1;
            while (pos != -1) {
                if (pos - prev > 1) {
                    ++count;
                }
                prev = pos;
                pos = this.delimeted.indexOf(this.delimeter, pos + 1);
            }
            if (prev < delimeted_length - 1 & (prev != this.index - 1 | count == 0)) {
                ++count;
            }
        }
        return count;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        int idx;
        char[] delim = this.delimeted.toCharArray();
        int delimeted_length = delim.length;
        if (!this.delimTokens && this.delimeter != -1) {
            for (idx = this.index; idx < delimeted_length && delim[idx] == this.delimeter; ++idx) {
            }
        }
        this.index = idx;
        return idx < delimeted_length;
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public String nextToken() {
        int idx;
        char[] delim = this.delimeted.toCharArray();
        int delimeted_length = delim.length;
        if (this.delimeter != -1) {
            if (!this.delimTokens) {
                for (idx = this.index; idx < delimeted_length && delim[idx] == this.delimeter; ++idx) {
                }
            }
            if (idx < delimeted_length) {
                int pos = idx;
                if (pos == (idx = this.delimeted.indexOf(this.delimeter, idx))) {
                    ++idx;
                } else if (idx == -1) {
                    idx = delimeted_length;
                }
                this.index = idx;
                return this.base.substring(pos, idx);
            }
        } else if (idx < delimeted_length) {
            this.index = delimeted_length;
            return this.base;
        }
        throw new NoSuchElementException();
    }

    public String nextToken(String delim) {
        this.setDelimeters(delim);
        return this.nextToken();
    }

    private void setDelimeters(String delim) {
        int delim_length = delim.length();
        if (delim_length == 0) {
            this.delimeter = -1;
        } else {
            char dlm = delim.charAt(0);
            this.delimeter = dlm;
            this.delimeted = this.base = this.base.substring(this.index);
            this.index = 0;
            for (int i = 1; i < delim_length; ++i) {
                this.delimeted = this.delimeted.replace(delim.charAt(i), dlm);
            }
        }
    }
}

