/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Hashtable
extends Dictionary
implements Cloneable,
Serializable,
Map {
    private static final long serialVersionUID = 1421746759512286392L;
    protected transient Object[] keys;
    protected transient Object[] values;
    private float loadFactor;
    private int threshold;
    private transient int capacity;
    private transient int occupancy;
    private static final int DEFAULT_CAPACITY = 101;
    private transient int modCount;

    public Hashtable(int initialCapacity, float loadFactor) throws IllegalArgumentException {
        if (initialCapacity < 0 || loadFactor <= 0.0f) {
            throw new IllegalArgumentException();
        }
        if (loadFactor > 1.0f) {
            loadFactor = 0.75f;
        }
        this.capacity = initialCapacity < 5 ? 5 : initialCapacity;
        this.keys = new Object[this.capacity];
        this.values = new Object[this.capacity];
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)this.capacity * loadFactor);
    }

    public Hashtable(int initialCapacity) throws IllegalArgumentException {
        this(initialCapacity, 0.75f);
    }

    public Hashtable() {
        this(101, 0.75f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable(Map t) {
        this(t.size() * 4 / 3 + 2);
        Map map = t;
        synchronized (map) {
            int n = t.size();
            Object[] mapkeys = t.keySet().toArray();
            for (int i = 0; i < n; ++i) {
                this.put(mapkeys[i], t.get(mapkeys[i]));
            }
        }
    }

    protected int firstBusySlot(int i) {
        int cap = this.capacity;
        Object[] k = this.keys;
        if (i >= 0) {
            while (i < cap) {
                if (k[i] != null) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public synchronized void putAll(Map m) throws NullPointerException {
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = (Map.Entry)it.next();
            this.put(me.getKey(), me.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String result = "{";
        int i = 0;
        boolean exhausted = false;
        while (!exhausted) {
            Hashtable hashtable = this;
            synchronized (hashtable) {
                i = this.firstBusySlot(i);
                if (i < 0) {
                    exhausted = true;
                } else {
                    if (result.length() > 1) {
                        result = result + ", ";
                    }
                    result = result + this.keys[i] + "=" + this.values[i];
                }
            }
            ++i;
        }
        result = result + "}";
        return result;
    }

    public synchronized Object clone() {
        Object that = null;
        try {
            that = super.clone();
            Hashtable that_hashtable = (Hashtable)that;
            that_hashtable.keys = new Object[this.capacity];
            System.arraycopy(this.keys, 0, that_hashtable.keys, 0, this.capacity);
            that_hashtable.values = new Object[this.capacity];
            System.arraycopy(this.values, 0, that_hashtable.values, 0, this.capacity);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return that;
    }

    public void rehash() {
        int newsize = this.capacity * 2 + 1;
        int oldsize = this.capacity;
        Object[] oldkeys = this.keys;
        Object[] oldvalues = this.values;
        Object[] newkeys = new Object[newsize];
        Object[] newvalues = new Object[newsize];
        this.capacity = newsize;
        this.threshold = (int)((float)this.capacity * this.loadFactor);
        this.keys = newkeys;
        this.values = newvalues;
        block0: for (int oldindex = 0; oldindex < oldsize; ++oldindex) {
            Object key = oldkeys[oldindex];
            if (key == null) continue;
            int hash = key.hashCode() % newsize;
            while (true) {
                if (hash < 0) {
                    hash += newsize;
                }
                if (newkeys[hash] == null) {
                    newkeys[hash] = key;
                    newvalues[hash] = oldvalues[oldindex];
                    continue block0;
                }
                --hash;
            }
        }
    }

    public int size() {
        return this.occupancy;
    }

    public boolean isEmpty() {
        return this.occupancy == 0;
    }

    private void deleteSlot(int slotIndex) {
        --this.occupancy;
        int current = slotIndex;
        while (true) {
            this.keys[current] = null;
            int vacant = current;
            boolean happy = true;
            while (happy) {
                int n = current = current == 0 ? this.capacity - 1 : current - 1;
                if (this.keys[current] == null) {
                    return;
                }
                int home = this.keys[current].hashCode() % this.capacity;
                if (home < 0) {
                    home += this.capacity;
                }
                int distance1 = current <= home ? home - current : this.capacity + home - current;
                int distance2 = current <= vacant ? vacant - current : this.capacity + vacant - current;
                happy = distance1 < distance2;
            }
            this.keys[vacant] = this.keys[current];
            this.values[vacant] = this.values[current];
        }
    }

    public synchronized Object get(Object key) {
        int cap = this.capacity;
        int hash = key.hashCode() % cap;
        Object[] k = this.keys;
        while (true) {
            Object k2;
            if (hash < 0) {
                hash += cap;
            }
            if ((k2 = k[hash]) == null) {
                return null;
            }
            if (key.equals(k2)) {
                return this.values[hash];
            }
            --hash;
        }
    }

    public synchronized Object put(Object key, Object newvalue) throws NullPointerException {
        if (newvalue == null) {
            throw new NullPointerException();
        }
        int cap = this.capacity;
        int hash = key.hashCode() % cap;
        Object[] k = this.keys;
        while (true) {
            Object k2;
            if (hash < 0) {
                hash += cap;
            }
            if ((k2 = k[hash]) == null) {
                k[hash] = key;
                this.values[hash] = newvalue;
                ++this.occupancy;
                if (this.occupancy >= this.threshold) {
                    this.rehash();
                }
                return null;
            }
            if (key.equals(k2)) {
                Object oldvalue = this.values[hash];
                this.values[hash] = newvalue;
                return oldvalue;
            }
            --hash;
        }
    }

    public synchronized Object remove(Object key) {
        int cap = this.capacity;
        int hashcode = key.hashCode() % cap;
        while (true) {
            if (hashcode < 0) {
                hashcode += cap;
            }
            if (this.keys[hashcode] == null) {
                return null;
            }
            if (key.equals(this.keys[hashcode])) {
                Object oldvalue = this.values[hashcode];
                this.deleteSlot(hashcode);
                return oldvalue;
            }
            --hashcode;
        }
    }

    public Set keySet() {
        return new HashtableKeySet();
    }

    private Object deleteInHt(Object key) {
        return this.remove(key);
    }

    public Set entrySet() {
        return new HashtableSet();
    }

    public Collection values() {
        return new HashtableValues();
    }

    public Enumeration keys() {
        return new HashtableKeyEnum();
    }

    public Enumeration elements() {
        return new HashtableElementEnum();
    }

    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    public boolean contains(Object value) {
        int nextSlot = this.firstBusySlot(0);
        Object[] v = this.values;
        while (nextSlot >= 0) {
            if (value.equals(v[nextSlot])) {
                return true;
            }
            nextSlot = this.firstBusySlot(nextSlot + 1);
        }
        return false;
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public void clear() {
        this.keys = new Object[this.capacity];
        this.values = new Object[this.capacity];
        this.occupancy = 0;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.capacity);
        s.writeInt(this.occupancy);
        int nextSlot = this.firstBusySlot(0);
        for (int i = 0; i < this.occupancy; ++i) {
            s.writeObject(this.keys[nextSlot]);
            s.writeObject(this.values[nextSlot]);
            nextSlot = this.firstBusySlot(nextSlot + 1);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.capacity = s.readInt();
        int local_oc = s.readInt();
        this.keys = new Object[this.capacity];
        this.values = new Object[this.capacity];
        for (int i = 0; i < local_oc; ++i) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.put(key, value);
        }
    }

    public static void test() {
        Hashtable h = new Hashtable();
        h.put(new String("FC"), new String("SuperFre'"));
        h.put(new String("EG"), new String("Williams"));
        h.put(new String("BP"), new String("Placky"));
        h.put(new String("SC"), new String("Sammy boy"));
        Enumeration k = h.keys();
        Enumeration e = h.elements();
        System.out.println("keys:");
        while (k.hasMoreElements()) {
            System.out.println(k.nextElement());
        }
        System.out.println("elements:");
        while (e.hasMoreElements()) {
            System.out.println(e.nextElement());
        }
    }

    public synchronized boolean equals(Object c) {
        if (c == this) {
            return true;
        }
        if (!(c instanceof Map)) {
            return false;
        }
        Map target = (Map)c;
        if (!((Object)this.keySet()).equals(target.keySet())) {
            return false;
        }
        Iterator it = target.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = (Map.Entry)it.next();
            Object value = me.getValue();
            if (value != null ? value.equals(this.get(me.getKey())) : this.get(me.getKey()) == null) continue;
            return false;
        }
        return true;
    }

    public synchronized int hashCode() {
        int hash = 0;
        int pos = this.firstBusySlot(0);
        while (pos != -1) {
            hash += this.keys[pos].hashCode() ^ this.values[pos].hashCode();
            pos = this.firstBusySlot(pos + 1);
        }
        return hash;
    }

    private class HashtableValues
    extends AbstractCollection {
        public Iterator iterator() {
            return new ValuesIterator();
        }

        public int size() {
            return Hashtable.this.occupancy;
        }
    }

    private class ValuesIterator
    implements Iterator {
        int pos;
        int oldpos;
        int mc;
        int status;

        public ValuesIterator() {
            this.pos = Hashtable.this.firstBusySlot(0);
            this.oldpos = -1;
            this.mc = Hashtable.this.modCount;
            this.status = 0;
        }

        public boolean hasNext() {
            return Hashtable.this.firstBusySlot(this.pos) != -1;
        }

        public Object next() {
            if (Hashtable.this.modCount != this.mc) {
                throw new ConcurrentModificationException("don't change the set please");
            }
            this.status = 1;
            if (Hashtable.this.firstBusySlot(this.pos) == -1) {
                throw new NoSuchElementException("no elements left");
            }
            this.oldpos = this.pos;
            this.pos = Hashtable.this.firstBusySlot(this.pos + 1);
            return Hashtable.this.values[this.oldpos];
        }

        public void remove() {
            if (Hashtable.this.modCount != this.mc) {
                throw new ConcurrentModificationException("don't change the set please");
            }
            if (this.status != 1) {
                throw new IllegalStateException("do a next() operation before remove()");
            }
            Hashtable.this.deleteInHt(Hashtable.this.keys[this.oldpos]);
            this.status = -1;
            ++this.mc;
        }
    }

    private class HashtableKeySet
    extends AbstractSet {
        public Iterator iterator() {
            return new KeySetIterator();
        }

        public int size() {
            return Hashtable.this.occupancy;
        }
    }

    private class KeySetIterator
    implements Iterator {
        int pos;
        int oldpos;
        int mc;
        int status;

        public KeySetIterator() {
            this.pos = Hashtable.this.firstBusySlot(0);
            this.oldpos = -1;
            this.mc = Hashtable.this.modCount;
            this.status = 0;
        }

        public boolean hasNext() {
            return Hashtable.this.firstBusySlot(this.pos) != -1;
        }

        public Object next() {
            if (Hashtable.this.modCount != this.mc) {
                throw new ConcurrentModificationException("don't change the set please");
            }
            this.status = 1;
            if (Hashtable.this.firstBusySlot(this.pos) == -1) {
                throw new NoSuchElementException("no elements left");
            }
            this.oldpos = this.pos;
            this.pos = Hashtable.this.firstBusySlot(this.pos + 1);
            return Hashtable.this.keys[this.oldpos];
        }

        public void remove() {
            if (Hashtable.this.modCount != this.mc) {
                throw new ConcurrentModificationException("don't change the set please");
            }
            if (this.status != 1) {
                throw new IllegalStateException("do a next() operation before remove()");
            }
            Hashtable.this.deleteInHt(Hashtable.this.keys[this.oldpos]);
            this.status = -1;
            ++this.mc;
        }
    }

    private class EntrySetIterator
    implements Iterator {
        int pos;
        int oldpos;
        int mc;
        int status;

        public EntrySetIterator() {
            this.pos = Hashtable.this.firstBusySlot(0);
            this.oldpos = -1;
            this.mc = Hashtable.this.modCount;
            this.status = 0;
        }

        public boolean hasNext() {
            if (Hashtable.this.modCount != this.mc) {
                throw new ConcurrentModificationException("don't change the set please");
            }
            return Hashtable.this.firstBusySlot(this.pos) != -1;
        }

        public Object next() {
            if (Hashtable.this.modCount != this.mc) {
                throw new ConcurrentModificationException("don't change the set please");
            }
            this.status = 1;
            if (Hashtable.this.firstBusySlot(this.pos) == -1) {
                throw new NoSuchElementException("no elements left");
            }
            this.oldpos = this.pos;
            this.pos = Hashtable.this.firstBusySlot(this.pos + 1);
            return new HashtableMapEntry(Hashtable.this.keys[this.oldpos], Hashtable.this.values[this.oldpos]);
        }

        public void remove() {
            if (Hashtable.this.modCount != this.mc) {
                throw new ConcurrentModificationException("don't change the set please");
            }
            if (this.status != 1) {
                throw new IllegalStateException("do a next() operation before remove()");
            }
            Hashtable.this.deleteInHt(Hashtable.this.keys[this.oldpos]);
            this.status = -1;
        }
    }

    private class HashtableSet
    extends AbstractSet {
        public Iterator iterator() {
            return new EntrySetIterator();
        }

        public int size() {
            return Hashtable.this.occupancy;
        }
    }

    private class HashtableMapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        public HashtableMapEntry(Object k, Object v) {
            this.key = k;
            this.value = v;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object nv) {
            Object ov = this.value;
            this.value = nv;
            return ov;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e == null) {
                return false;
            }
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        public int hashCode() {
            int kc = this.key == null ? 0 : this.key.hashCode();
            int vc = this.value == null ? 0 : this.value.hashCode();
            return kc ^ vc;
        }
    }

    protected class HashtableElementEnum
    implements Enumeration {
        private int nextSlot;

        protected HashtableElementEnum() {
            this.nextSlot = Hashtable.this.firstBusySlot(0);
        }

        public boolean hasMoreElements() {
            return Hashtable.this.firstBusySlot(this.nextSlot) >= 0;
        }

        public synchronized Object nextElement() throws NoSuchElementException {
            int thisSlot = Hashtable.this.firstBusySlot(this.nextSlot);
            if (thisSlot < 0) {
                throw new NoSuchElementException();
            }
            this.nextSlot = Hashtable.this.firstBusySlot(thisSlot + 1);
            return Hashtable.this.values[thisSlot];
        }
    }

    protected class HashtableKeyEnum
    implements Enumeration,
    Iterator {
        private int nextSlot = 0;

        protected HashtableKeyEnum() {
        }

        public boolean hasMoreElements() {
            return Hashtable.this.firstBusySlot(this.nextSlot) >= 0;
        }

        public boolean hasNext() {
            return Hashtable.this.firstBusySlot(this.nextSlot) >= 0;
        }

        public synchronized Object nextElement() throws NoSuchElementException {
            int thisSlot = Hashtable.this.firstBusySlot(this.nextSlot);
            if (thisSlot < 0) {
                throw new NoSuchElementException();
            }
            this.nextSlot = Hashtable.this.firstBusySlot(thisSlot + 1);
            return Hashtable.this.keys[thisSlot];
        }

        public Object next() throws NoSuchElementException {
            int thisSlot = Hashtable.this.firstBusySlot(this.nextSlot);
            if (thisSlot < 0) {
                throw new NoSuchElementException();
            }
            this.nextSlot = Hashtable.this.firstBusySlot(thisSlot + 1);
            return Hashtable.this.keys[thisSlot];
        }

        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new RuntimeException("not yet supported");
        }
    }
}

