/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ArrayList
extends AbstractList
implements List,
Cloneable,
Serializable {
    private transient Object[] elements;
    private int size;
    private static final int defaultCapacity = 7;

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.elements.length);
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int local_oc = s.readInt();
        this.elements = new Object[local_oc];
        for (int i = 0; i < this.size; ++i) {
            this.elements[i] = s.readObject();
        }
    }

    public ArrayList() {
        this(7);
    }

    public ArrayList(int initialCapacity) {
        this.elements = new Object[initialCapacity];
        this.size = 0;
    }

    public ArrayList(Collection c) {
        this((int)((float)c.size() * 1.1f));
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.elements[this.size] = it.next();
            ++this.size;
        }
    }

    public void trimToSize() {
        if (this.size < this.elements.length) {
            Object[] oldElements = this.elements;
            this.elements = new Object[this.size];
            System.arraycopy(oldElements, 0, this.elements, 0, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        if (this.elements.length < minCapacity) {
            Object[] oldElements = this.elements;
            int oldlength = this.size;
            this.elements = new Object[minCapacity];
            System.arraycopy(oldElements, 0, this.elements, 0, oldlength);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object elem) {
        int i;
        if (elem == null) {
            for (i = 0; i < this.size; ++i) {
                if (this.elements[i] != null) continue;
                return true;
            }
        } else {
            while (i < this.size) {
                if (elem.equals(this.elements[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public int indexOf(Object elem) {
        int i;
        if (elem == null) {
            for (i = 0; i < this.size; ++i) {
                if (this.elements[i] != null) continue;
                return i;
            }
        } else {
            while (i < this.size) {
                if (elem.equals(this.elements[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object elem) {
        int i;
        if (elem == null) {
            for (i = this.size - 1; i >= 0; --i) {
                if (this.elements[i] != null) continue;
                return i;
            }
        } else {
            while (i >= 0) {
                if (elem.equals(this.elements[i])) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public Object clone() {
        ArrayList al = null;
        try {
            al = (ArrayList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        al.elements = new Object[this.elements.length];
        System.arraycopy(this.elements, 0, al.elements, 0, this.size);
        return al;
    }

    public Object[] toArray() {
        Object[] answer = new Object[this.size];
        System.arraycopy(this.elements, 0, answer, 0, this.size);
        return answer;
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            Class ctype = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(ctype, this.size);
        }
        System.arraycopy(this.elements, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public Object get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.elements[index];
    }

    public Object set(int index, Object element) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        Object answer = this.elements[index];
        this.elements[index] = element;
        return answer;
    }

    public boolean add(Object o) {
        this.ensureCapacity(this.size + 1);
        int position = this.size++;
        this.elements[position] = o;
        ++this.modCount;
        return true;
    }

    public void add(int index, Object element) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Asked index " + index + " in array of size " + this.size);
        }
        int todo = this.size - index;
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, index, this.elements, index + 1, todo);
        this.elements[index] = element;
        ++this.size;
        ++this.modCount;
    }

    public Object remove(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Asked index " + index + " in array of size " + this.size);
        }
        Object answer = this.elements[index];
        int todo = this.size - index - 1;
        System.arraycopy(this.elements, index + 1, this.elements, index, todo);
        ++this.modCount;
        --this.size;
        return answer;
    }

    public void clear() {
        ++this.modCount;
        int oldsize = this.size;
        this.size = 0;
        for (int i = 0; i < oldsize; ++i) {
            this.elements[i] = null;
        }
    }

    public boolean addAll(Collection c) {
        if (c.isEmpty()) {
            return false;
        }
        this.ensureCapacity(this.size + c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return true;
    }

    public boolean addAll(int index, Collection c) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Asked index " + index + " in array of size " + this.size);
        }
        if (c.isEmpty()) {
            return false;
        }
        Iterator it = c.iterator();
        int todo = this.size - index;
        int extra = c.size();
        this.ensureCapacity(this.size + extra);
        System.arraycopy(this.elements, index, this.elements, index + extra, todo);
        for (int i = 0; i < extra; ++i) {
            this.elements[index + i] = it.next();
        }
        ++this.modCount;
        return true;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        if (toIndex != this.size) {
            System.arraycopy(this.elements, toIndex, this.elements, fromIndex, this.size - toIndex);
        }
        for (int i = fromIndex + this.size - toIndex; i < this.size; ++i) {
            this.elements[i] = null;
        }
        ++this.modCount;
        this.size -= toIndex - fromIndex;
    }
}

