/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMap
implements Map {
    private transient AbstractSet keySet = null;
    private transient AbstractCollection valuecol = null;

    protected AbstractMap() {
    }

    public int size() {
        return this.entrySet().size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsValue(Object value) {
        Set maps = this.entrySet();
        boolean found = false;
        Iterator it = maps.iterator();
        while (!found && it.hasNext()) {
            Map.Entry myEntry = (Map.Entry)it.next();
            if (!(value == null ? myEntry.getValue() == null : value.equals(myEntry.getValue()))) continue;
            found = true;
        }
        return found;
    }

    public boolean containsKey(Object key) {
        Set maps = this.entrySet();
        boolean found = false;
        Iterator it = maps.iterator();
        while (!found && it.hasNext()) {
            Map.Entry myEntry = (Map.Entry)it.next();
            if (!(key == null ? myEntry.getKey() == null : key.equals(myEntry.getKey()))) continue;
            found = true;
        }
        return found;
    }

    public Object get(Object key) {
        Object answer = null;
        Set maps = this.entrySet();
        boolean found = false;
        Iterator it = maps.iterator();
        while (!found && it.hasNext()) {
            Map.Entry myEntry = (Map.Entry)it.next();
            if (!(key == null ? myEntry.getKey() == null : key.equals(myEntry.getKey()))) continue;
            found = true;
            answer = myEntry.getValue();
        }
        return answer;
    }

    public Object put(Object key, Object value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        Object answer = null;
        Set maps = this.entrySet();
        boolean found = false;
        Iterator it = maps.iterator();
        while (!found && it.hasNext()) {
            Map.Entry myEntry = (Map.Entry)it.next();
            if (!(key == null ? myEntry.getKey() == null : key.equals(myEntry.getKey()))) continue;
            found = true;
            answer = myEntry.getValue();
            it.remove();
        }
        return answer;
    }

    public void putAll(Map t) {
        Iterator addIt = t.entrySet().iterator();
        while (addIt.hasNext()) {
            Map.Entry myEntry = (Map.Entry)addIt.next();
            this.put(myEntry.getKey(), myEntry.getValue());
        }
    }

    public void clear() {
        this.entrySet().clear();
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KSet();
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.valuecol == null) {
            this.valuecol = new VCollection();
        }
        return this.valuecol;
    }

    public abstract Set entrySet();

    public boolean equals(Object o) {
        if (!(o instanceof Map)) {
            return false;
        }
        Map target = (Map)o;
        if (!((Object)this.keySet()).equals(target.keySet())) {
            return false;
        }
        Iterator it = target.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = (Map.Entry)it.next();
            Object value = me.getValue();
            if (value != null ? value.equals(this.get(me.getKey())) : this.get(me.getKey()) == null) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int answer = 0;
        Set maps = this.entrySet();
        Iterator it = maps.iterator();
        boolean go = it.hasNext();
        while (go) {
            Map.Entry myEntry = (Map.Entry)it.next();
            answer += ((Object)myEntry).hashCode();
            go = it.hasNext();
        }
        return answer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        Set maps = this.entrySet();
        Iterator it = maps.iterator();
        boolean go = it.hasNext();
        while (go) {
            Map.Entry myEntry = (Map.Entry)it.next();
            sb.append(String.valueOf(myEntry.getKey()));
            sb.append("=");
            sb.append(String.valueOf(myEntry.getValue()));
            go = it.hasNext();
            if (!go) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    private class VCollection
    extends AbstractCollection {
        public boolean contains(Object e) {
            return AbstractMap.this.containsValue(e);
        }

        public Iterator iterator() {
            return new VIterator();
        }

        public int size() {
            return AbstractMap.this.entrySet().size();
        }
    }

    private class VIterator
    implements Iterator {
        private Iterator it;

        public VIterator() {
            this.it = AbstractMap.this.entrySet().iterator();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            return ((Map.Entry)this.it.next()).getValue();
        }

        public void remove() {
            this.it.remove();
        }
    }

    private class KIterator
    implements Iterator {
        private Iterator it;

        public KIterator() {
            this.it = AbstractMap.this.entrySet().iterator();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            return ((Map.Entry)this.it.next()).getKey();
        }

        public void remove() {
            this.it.remove();
        }
    }

    private class KSet
    extends AbstractSet {
        public boolean contains(Object e) {
            return AbstractMap.this.containsKey(e);
        }

        public Iterator iterator() {
            return new KIterator();
        }

        public int size() {
            return AbstractMap.this.entrySet().size();
        }
    }
}

