/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractCollection
implements Collection {
    protected AbstractCollection() {
    }

    public abstract Iterator iterator();

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object o) throws UnsupportedOperationException {
        Iterator it = this.iterator();
        if (o == null) {
            while (it.hasNext()) {
                if (it.next() != null) continue;
                return true;
            }
        } else {
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                return true;
            }
        }
        return false;
    }

    public Object[] toArray() {
        Iterator it = this.iterator();
        Object[] newArray = new Object[this.size()];
        int counter = 0;
        while (it.hasNext()) {
            newArray[counter++] = it.next();
        }
        return newArray;
    }

    public Object[] toArray(Object[] a) throws NullPointerException, ArrayStoreException {
        if (a.length < this.size()) {
            Class ctype = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(ctype, this.size());
        }
        Object[] b = this.toArray();
        System.arraycopy(b, 0, a, 0, this.size());
        if (a.length > this.size()) {
            a[this.size()] = null;
        }
        return a;
    }

    public boolean add(Object o) throws UnsupportedOperationException, NullPointerException, ClassCastException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) throws UnsupportedOperationException {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object ito = i.next();
            if (!(o == null ? ito == null : o.equals(ito))) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection c) throws UnsupportedOperationException {
        Iterator it = c.iterator();
        boolean modified = false;
        while (it.hasNext()) {
            if (!this.add(it.next())) continue;
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(Collection c) throws UnsupportedOperationException {
        Iterator it = c.iterator();
        boolean modified = false;
        while (it.hasNext()) {
            Object o = it.next();
            while (this.remove(o)) {
                modified = true;
            }
        }
        return modified;
    }

    public void clear() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            it.remove();
        }
    }

    public boolean retainAll(Collection c) throws UnsupportedOperationException {
        Iterator it = this.iterator();
        boolean modified = false;
        while (it.hasNext()) {
            Object o = it.next();
            if (c.contains(o)) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    public String toString() {
        String newString = "[";
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (newString.length() > 1) {
                newString = newString + ", ";
            }
            newString = newString + String.valueOf(it.next());
        }
        newString = newString + "]";
        return newString;
    }
}

