/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MessageFormat
extends Format {
    private static final long serialVersionUID = 6479157306784022952L;
    private static final FieldPosition TRASHPOSITION = new FieldPosition(0);
    private int[] argumentNumbers;
    private Format[] formats;
    private Locale locale;
    private int maxOffset;
    private int[] offsets;
    private String pattern;
    private transient String[] subPatterns;
    private transient String origPattern;

    private final Format getDateTimeFormat(StringTokenizer st, boolean time) {
        int style = 2;
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("short")) {
                style = 3;
            } else if (token.equals("medium")) {
                style = 2;
            } else if (token.equals("long")) {
                style = 1;
            } else if (token.equals("full")) {
                style = 0;
            } else {
                return new SimpleDateFormat(token, this.locale);
            }
        }
        if (time) {
            return DateFormat.getTimeInstance(style, this.locale);
        }
        return DateFormat.getDateInstance(style, this.locale);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int applyFormat(int idx, String pattern) {
        int end = pattern.indexOf(125, idx);
        int last = pattern.indexOf(123, idx);
        while (last < end && last != -1 && end != -1) {
            end = pattern.indexOf(125, end + 1);
            last = pattern.indexOf(123, last + 1);
        }
        if (end == -1 || end == idx) {
            throw new IllegalArgumentException("bad pattern");
        }
        StringTokenizer st = new StringTokenizer(pattern.substring(idx, end), ",");
        try {
            this.argumentNumbers[++this.maxOffset] = Integer.parseInt(st.nextToken());
            if (this.argumentNumbers[this.maxOffset] < 0 || this.argumentNumbers[this.maxOffset] > 9) {
                throw new IllegalArgumentException("bad pattern: bad argument number " + this.argumentNumbers[this.maxOffset]);
            }
            if (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.equals("time")) {
                    this.formats[this.maxOffset] = this.getDateTimeFormat(st, true);
                    return end;
                } else if (token.equals("date")) {
                    this.formats[this.maxOffset] = this.getDateTimeFormat(st, true);
                    return end;
                } else if (token.equals("number")) {
                    if (st.hasMoreTokens()) {
                        token = st.nextToken();
                        String trimmed = token.trim();
                        if (trimmed.equals("currency")) {
                            this.formats[this.maxOffset] = NumberFormat.getCurrencyInstance(this.locale);
                            return end;
                        } else if (trimmed.equals("percent")) {
                            this.formats[this.maxOffset] = NumberFormat.getPercentInstance(this.locale);
                            return end;
                        } else if (trimmed.equals("integer")) {
                            NumberFormat nf = NumberFormat.getNumberInstance(this.locale);
                            nf.setParseIntegerOnly(true);
                            this.formats[this.maxOffset] = nf;
                            return end;
                        } else {
                            this.formats[this.maxOffset] = new DecimalFormat(token, new DecimalFormatSymbols(this.locale));
                        }
                        return end;
                    } else {
                        this.formats[this.maxOffset] = NumberFormat.getInstance(this.locale);
                    }
                    return end;
                } else {
                    if (!token.equals("choice")) throw new IllegalArgumentException("bad pattern");
                    this.formats[this.maxOffset] = st.hasMoreTokens() ? new ChoiceFormat(st.nextToken()) : new ChoiceFormat("0# ");
                }
                return end;
            } else {
                this.formats[this.maxOffset] = null;
            }
            return end;
        }
        catch (RuntimeException rt) {
            throw new IllegalArgumentException("bad pattern");
        }
    }

    public void applyPattern(String pattern) {
        int len = pattern.length();
        this.maxOffset = -1;
        StringBuffer pat = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char ch = pattern.charAt(i);
            if (ch == '\'' && ++i < len) {
                pat.append(pattern.charAt(i));
            } else if (ch == '{') {
                i = this.applyFormat(i + 1, pattern);
                this.offsets[this.maxOffset] = pat.length();
            } else {
                pat.append(ch);
            }
            ++i;
        }
        this.subPatterns = null;
        this.origPattern = pattern;
        this.pattern = pat.toString();
    }

    public Object clone() {
        MessageFormat mf = (MessageFormat)super.clone();
        mf.argumentNumbers = (int[])this.argumentNumbers.clone();
        mf.offsets = this.offsets;
        mf.formats = (Format[])this.formats.clone();
        return mf;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MessageFormat)) {
            return false;
        }
        MessageFormat mf = (MessageFormat)o;
        boolean bl = false;
        if (this.pattern.equals(mf.pattern) && this.maxOffset == mf.maxOffset && this.locale.equals(mf.locale) && Arrays.equals(this.formats, mf.formats) && Arrays.equals(this.offsets, mf.offsets) && Arrays.equals(this.argumentNumbers, mf.argumentNumbers)) {
            bl = true;
        }
        return bl;
    }

    public static String format(String pattern, Object[] args) {
        return new MessageFormat(pattern).format(args, new StringBuffer(), (FieldPosition)null).toString();
    }

    public final StringBuffer format(Object[] args, StringBuffer dest, FieldPosition pos) {
        if (this.subPatterns == null) {
            this.createSubPatterns();
        }
        int i = 0;
        while (i <= this.maxOffset) {
            Format format = this.formats[i];
            dest.append(this.subPatterns[i]);
            if (format == null) {
                Object o = args[this.argumentNumbers[i]];
                if (o instanceof Date) {
                    DateFormat.getDateTimeInstance(2, 2, this.locale).format((Date)o, dest, TRASHPOSITION);
                } else if (o instanceof Number) {
                    NumberFormat.getInstance(this.locale).format(((Number)o).doubleValue(), dest, TRASHPOSITION);
                } else {
                    dest.append(o);
                }
            } else {
                format.format(args[this.argumentNumbers[i]], dest, TRASHPOSITION);
            }
            ++i;
        }
        dest.append(this.subPatterns[this.maxOffset + 1]);
        return dest;
    }

    public final StringBuffer format(Object obj, StringBuffer dest, FieldPosition pos) {
        if (obj instanceof Object[]) {
            return this.format((Object[])obj, dest, pos);
        }
        Object[] args = new Object[]{obj};
        return this.format(args, dest, pos);
    }

    public Format[] getFormats() {
        return this.formats;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        return this.locale.hashCode() ^ this.pattern.hashCode() ^ this.maxOffset;
    }

    public Object[] parse(String src, ParsePosition pos) {
        if (this.subPatterns == null) {
            this.createSubPatterns();
        }
        Object[] res = new Object[10];
        int p = pos.getIndex();
        int i = 0;
        while (i <= this.maxOffset) {
            String s = this.subPatterns[i];
            int len = s.length();
            if (!src.regionMatches(p, s, 0, len)) {
                pos.setErrorIndex(p);
                return null;
            }
            p += len;
            Format format = this.formats[i];
            if (format == null) {
                int end = src.indexOf(this.subPatterns[i + 1], p);
                if (end == -1) {
                    pos.setErrorIndex(p);
                    return null;
                }
                res[this.argumentNumbers[i]] = src.substring(p, end);
                p = end;
            } else {
                pos.setIndex(p);
                Object o = format.parseObject(src, pos);
                if (o == null) {
                    return null;
                }
                res[this.argumentNumbers[i]] = o;
                p = pos.getIndex();
            }
            ++i;
        }
        String s = this.subPatterns[this.maxOffset + 1];
        int len = s.length();
        if (!src.regionMatches(p, s, 0, len)) {
            pos.setErrorIndex(p);
            return null;
        }
        pos.setIndex(p + len);
        return res;
    }

    public Object[] parse(String src) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Object[] res = this.parse(src, pos);
        if (res == null) {
            throw new ParseException("parsing failed!", pos.getErrorIndex());
        }
        return res;
    }

    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    public void setFormat(int num, Format format) {
        this.formats[num] = format;
    }

    public void setFormats(Format[] formats) {
        this.formats = formats;
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public String toPattern() {
        if (this.origPattern == null) {
            if (this.subPatterns == null) {
                this.createSubPatterns();
            }
            StringBuffer pattern = new StringBuffer();
            int i = 0;
            while (i <= this.maxOffset) {
                this.addQuotes(this.subPatterns[i], pattern);
                pattern.append('{');
                pattern.append(this.argumentNumbers[i]);
                Format format = this.formats[i];
                if (format != null) {
                    if (format instanceof ChoiceFormat) {
                        pattern.append(",choice,");
                        pattern.append(((ChoiceFormat)format).toPattern());
                    } else if (format instanceof DecimalFormat) {
                        pattern.append(",number,");
                        pattern.append(((DecimalFormat)format).toPattern());
                    } else if (format instanceof SimpleDateFormat) {
                        pattern.append(",date,");
                        pattern.append(((SimpleDateFormat)format).toPattern());
                    }
                }
                pattern.append('}');
                ++i;
            }
            this.addQuotes(this.subPatterns[this.maxOffset + 1], pattern);
            this.origPattern = pattern.toString();
        }
        return this.origPattern;
    }

    private final void addQuotes(String pat, StringBuffer dest) {
        String sep = "'{";
        StringTokenizer st = new StringTokenizer(pat, sep, true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (sep.indexOf(token) != -1) {
                dest.append('\'');
            }
            dest.append(token);
        }
    }

    private final void createSubPatterns() {
        this.subPatterns = new String[this.maxOffset + 2];
        int prev = 0;
        int i = 0;
        while (i <= this.maxOffset) {
            int off = this.offsets[i];
            this.subPatterns[i] = this.pattern.substring(prev, off);
            prev = off;
            ++i;
        }
        this.subPatterns[this.maxOffset + 1] = this.pattern.substring(prev);
    }

    private final void debug() {
        System.out.println("ORIGINAL PATTERN = '" + this.origPattern + '\'');
        int i = 0;
        while (i <= this.maxOffset) {
            System.out.println("argNr " + this.argumentNumbers[i] + " using " + this.formats[i] + " off " + this.offsets[i]);
            ++i;
        }
    }

    private final /* synthetic */ void this() {
        this.argumentNumbers = new int[10];
        this.formats = new Format[10];
        this.locale = Locale.getDefault();
        this.offsets = new int[10];
    }

    public MessageFormat(String pattern) {
        this.this();
        this.applyPattern(pattern);
    }
}

