/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class DecimalFormat
extends NumberFormat {
    private static final DecimalFormatSymbols DEFAULT = new DecimalFormatSymbols();
    private static final long serialVersionUID = 864413376551465018L;
    private boolean decimalSeparatorAlwaysShown;
    private byte groupingSize = (byte)3;
    private byte minExponentDigits;
    private int multiplier = 1;
    private String negativePrefix = "-";
    private String negativeSuffix = "";
    private String positivePrefix = "";
    private String positiveSuffix = "";
    private int serialVersionOnStream = 1;
    private DecimalFormatSymbols symbols;
    private boolean useExponentialNotation;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.useExponentialNotation = false;
            this.serialVersionOnStream = 1;
        }
    }

    public DecimalFormat() {
        this.symbols = new DecimalFormatSymbols();
        super.setMaximumFractionDigits(340);
        super.setMaximumIntegerDigits(309);
        super.setMinimumIntegerDigits(1);
    }

    DecimalFormat(DecimalFormatSymbols dfs) {
        this.symbols = dfs;
    }

    public DecimalFormat(String pattern) {
        this(pattern, new DecimalFormatSymbols());
    }

    public DecimalFormat(String pattern, DecimalFormatSymbols dfs) {
        this.applyPattern(pattern, dfs);
        super.setMaximumIntegerDigits(309);
        this.symbols = dfs;
    }

    public void applyLocalizedPattern(String pattern) {
        this.applyPattern(pattern, this.symbols);
    }

    public void applyPattern(String pattern) {
        this.applyPattern(pattern, DEFAULT);
    }

    public Object clone() {
        DecimalFormat df = (DecimalFormat)super.clone();
        df.symbols = (DecimalFormatSymbols)this.symbols.clone();
        return df;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DecimalFormat)) {
            return false;
        }
        DecimalFormat df = (DecimalFormat)o;
        return this.symbols.equals(df.symbols) && this.decimalSeparatorAlwaysShown == df.decimalSeparatorAlwaysShown && this.minExponentDigits == df.minExponentDigits && this.multiplier == df.multiplier && this.negativePrefix.equals(df.negativePrefix) && this.negativeSuffix.equals(df.negativeSuffix) && this.positivePrefix.equals(df.positivePrefix) && this.positiveSuffix.equals(df.positiveSuffix) && this.useExponentialNotation == df.useExponentialNotation;
    }

    public StringBuffer format(double number, StringBuffer dest, FieldPosition pos) {
        boolean neg = number < 0.0;
        double d = 0.5 * Math.pow(10.0, -this.getMaximumFractionDigits());
        number = number * (double)this.multiplier + (neg ? -d : d);
        String value = String.valueOf(number);
        if (neg) {
            value = value.substring(1);
        }
        int p = value.indexOf(69);
        if (this.useExponentialNotation) {
            if (p == -1) {
                value = this.insertExpononent(value);
            }
            return this.formatExponent(value, dest, pos, neg);
        }
        if (p != -1) {
            StringBuffer buf = new StringBuffer(128);
            int exp = Integer.parseInt(value.substring(p + 1));
            p = value.indexOf(46);
            if (exp < 0) {
                int add = 1 - p - exp;
                this.addChars('0', add, buf);
                buf.append(value);
                buf.deleteCharAt(p += add < 0 ? 0 : add);
                buf.insert(p + exp, '.');
            } else {
                int add = exp + value.length() - p;
                buf.append(value);
                this.addChars('0', add, buf);
                buf.deleteCharAt(p);
                buf.insert(p + exp, '.');
            }
            value = buf.toString();
        }
        return this.format(value, dest, pos, neg);
    }

    public StringBuffer format(long number, StringBuffer dest, FieldPosition pos) {
        boolean neg = number < 0L;
        String value = String.valueOf(number * (long)this.multiplier) + '.';
        if (neg) {
            value = value.substring(1);
        }
        if (this.useExponentialNotation) {
            this.formatExponent(this.insertExpononent(value), dest, pos, neg);
        }
        return this.format(value, dest, pos, neg);
    }

    private StringBuffer format(String number, StringBuffer dest, FieldPosition pos, boolean neg) {
        int frac;
        int i;
        dest.append(neg ? this.negativePrefix : this.positivePrefix);
        int start = dest.length();
        int p = number.indexOf(46);
        int min = this.getMinimumIntegerDigits();
        if (min > p) {
            this.addChars(this.symbols.getZeroDigit(), min - p, dest);
            dest.append(number);
            p = min;
        } else {
            dest.append(number);
            int max = this.getMaximumIntegerDigits();
            if (max < p) {
                dest.delete(start, start + p - max);
                p = max;
            }
        }
        if (min == 0 && p == 1 && dest.charAt(start) == '0') {
            --p;
            dest.deleteCharAt(start);
        }
        if (this.isGroupingUsed()) {
            min = (p - 1) / this.groupingSize;
            int in = p + start;
            char ch = this.symbols.getGroupingSeparator();
            for (i = 0; i < min; ++i) {
                dest.insert(in -= this.groupingSize, ch);
            }
            p += min;
        }
        if ((min = this.getMinimumFractionDigits()) > (frac = dest.length() - start - p - 1)) {
            this.addChars(this.symbols.getZeroDigit(), min - frac, dest);
        } else {
            int max = this.getMaximumFractionDigits();
            if (max < frac) {
                dest.setLength(start + p + max + 1);
            }
        }
        if (!this.decimalSeparatorAlwaysShown) {
            boolean cut = true;
            for (i = p + 1 + start; i < dest.length(); ++i) {
                if (dest.charAt(i) == '0') continue;
                cut = false;
                break;
            }
            if (cut) {
                dest.setLength(p + start);
            }
        }
        switch (pos.getField()) {
            case 1: {
                pos.setBeginIndex(start + p + 1);
                pos.setEndIndex(dest.length());
                break;
            }
            case 0: {
                pos.setBeginIndex(start);
                pos.setEndIndex(start + p);
                break;
            }
        }
        int stop = dest.length();
        dest.append(neg ? this.negativeSuffix : this.positiveSuffix);
        return dest;
    }

    private StringBuffer formatExponent(String number, StringBuffer dest, FieldPosition pos, boolean neg) {
        throw new UnsupportedOperationException("No exponential formats supported yet");
    }

    private String insertExpononent(String s) {
        return s;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return this.symbols;
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    public int hashCode() {
        int hash = this.decimalSeparatorAlwaysShown ? -1431655766 : 0x55555555;
        hash ^= this.useExponentialNotation ? -858993460 : 0x33333333;
        return this.symbols.hashCode() ^ this.minExponentDigits ^ this.multiplier ^ this.negativePrefix.hashCode() ^ this.negativeSuffix.hashCode() ^ this.positivePrefix.hashCode() ^ this.positiveSuffix.hashCode();
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public Number parse(String str, ParsePosition pos) {
        int p;
        Number Num = null;
        int len = str.length();
        for (p = pos.getIndex(); p < len && Character.isWhitespace(str.charAt(p)); ++p) {
        }
        try {
            boolean positive = true;
            boolean returnlong = true;
            int preflen = -1;
            if (str.regionMatches(p, this.positivePrefix, 0, this.positivePrefix.length())) {
                preflen = this.positivePrefix.length();
            }
            if (str.regionMatches(p, this.negativePrefix, 0, this.negativePrefix.length()) && preflen < this.negativePrefix.length()) {
                positive = false;
                preflen = this.negativePrefix.length();
            }
            if (preflen == -1) {
                pos.setErrorIndex(p);
            } else {
                p += preflen;
                StringBuffer buf = new StringBuffer(64);
                if ((p = this.parseIntegerPart(buf, str, p)) < 0) {
                    pos.setErrorIndex(-p);
                } else {
                    if (p < len && str.charAt(p) == this.symbols.getDecimalSeparator()) {
                        char ch;
                        int count;
                        int start = ++p;
                        buf.append('.');
                        for (count = 0; p < len && count < this.maximumFractionDigits && (ch = str.charAt(p)) >= '0' && ch <= '9'; ++count, ++p) {
                            buf.append(ch);
                        }
                        if (count < this.minimumFractionDigits) {
                            pos.setErrorIndex(p);
                            return null;
                        }
                        if (start < p) {
                            returnlong = false;
                        } else {
                            buf.setLength(buf.length() - 1);
                        }
                    }
                    preflen = -1;
                    if (str.regionMatches(p, this.positiveSuffix, 0, this.positiveSuffix.length())) {
                        if (!positive && !this.positiveSuffix.equals(this.negativeSuffix) && this.positiveSuffix.length() > 0) {
                            pos.setErrorIndex(p);
                            return null;
                        }
                        preflen = this.positiveSuffix.length();
                    }
                    if (str.regionMatches(p, this.negativeSuffix, 0, this.negativeSuffix.length()) && preflen < this.negativeSuffix.length()) {
                        if (positive && !this.positivePrefix.equals(this.negativePrefix)) {
                            pos.setErrorIndex(p);
                            return null;
                        }
                        positive = false;
                        preflen = this.negativeSuffix.length();
                    }
                    if (preflen == -1) {
                        pos.setErrorIndex(p);
                        return null;
                    }
                    p += preflen;
                    if (!positive) {
                        buf.insert(0, '-');
                    }
                    Num = returnlong ? (Number)new Long(Long.parseLong(buf.toString()) * (long)this.multiplier) : (Number)new Double(Double.parseDouble(buf.toString()) * (double)this.multiplier);
                    pos.setIndex(p);
                }
            }
        }
        catch (RuntimeException rt) {
            pos.setErrorIndex(p);
            return null;
        }
        return Num;
    }

    private int parseIntegerPart(StringBuffer buf, String number, int pos) {
        int count;
        int len = number.length();
        if (this.isGroupingUsed()) {
            char sep = this.symbols.getGroupingSeparator();
            int group = 0;
            boolean first = true;
            while (pos < len && count < this.maximumIntegerDigits) {
                char ch = number.charAt(pos);
                if (ch >= '0' && ch <= '9') {
                    if (group == this.groupingSize) {
                        return -pos;
                    }
                    buf.append(ch);
                    ++count;
                    ++group;
                } else {
                    if (ch == sep) {
                        if (first || group == this.groupingSize) {
                            first = false;
                            group = 0;
                        } else {
                            return -pos;
                        }
                    }
                    break;
                }
                ++pos;
            }
        } else {
            char ch;
            for (count = 0; pos < len && count < this.maximumIntegerDigits && (ch = number.charAt(pos)) >= '0' && ch <= '9'; ++count, ++pos) {
                buf.append(ch);
            }
        }
        if (count < this.minimumIntegerDigits) {
            return -pos;
        }
        return pos;
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols syms) {
        this.symbols = syms;
    }

    public void setDecimalSeparatorAlwaysShown(boolean val) {
        this.decimalSeparatorAlwaysShown = val;
    }

    public void setGroupingSize(int size) {
        this.groupingSize = (byte)size;
    }

    public void setMaximumFractionDigits(int max) {
        if (max >= 340) {
            max = 340;
        }
        super.setMaximumFractionDigits(max);
    }

    public void setMaximumIntegerDigits(int max) {
        if (max >= 309) {
            max = 309;
        }
        super.setMaximumIntegerDigits(max);
    }

    public void setMinimumFractionDigits(int min) {
        if (min >= 340) {
            min = 340;
        }
        super.setMinimumFractionDigits(min);
    }

    public void setMinimumIntegerDigits(int min) {
        if (min >= 309) {
            min = 309;
        }
        super.setMinimumIntegerDigits(min);
    }

    public void setMultiplier(int mul) {
        this.multiplier = mul;
    }

    public void setNegativePrefix(String prefix) {
        this.negativePrefix = prefix;
    }

    public void setNegativeSuffix(String suffix) {
        this.negativeSuffix = suffix;
    }

    public void setPositivePrefix(String prefix) {
        this.positivePrefix = prefix;
    }

    public void setPositiveSuffix(String suffix) {
        this.positiveSuffix = suffix;
    }

    public String toLocalizedPattern() {
        return this.toPattern(this.symbols);
    }

    public String toPattern() {
        return this.toPattern(DEFAULT);
    }

    private String toPattern(DecimalFormatSymbols dfs) {
        StringBuffer buf = new StringBuffer(128);
        buf.append(this.positivePrefix);
        int pos = buf.length();
        int min = this.getMinimumIntegerDigits();
        this.addChars(dfs.getZeroDigit(), min, buf);
        if (this.isGroupingUsed()) {
            this.addChars(dfs.getDigit(), this.groupingSize + 1 - min, buf);
            int i = 1;
            if (min > this.groupingSize) {
                i = min / this.groupingSize;
                min += pos;
            } else {
                min = this.groupingSize + 1;
            }
            char ch = dfs.getGroupingSeparator();
            for (int j = 0; j < i; ++j) {
                buf.insert(min -= this.groupingSize, ch);
            }
        }
        min = this.getMinimumFractionDigits();
        int max = this.getMaximumFractionDigits();
        if (this.decimalSeparatorAlwaysShown || min > 0 || max > 0) {
            buf.append(dfs.getDecimalSeparator());
            this.addChars(dfs.getZeroDigit(), min, buf);
            this.addChars(dfs.getDigit(), max - min, buf);
        }
        String format = buf.substring(pos);
        buf.append(this.positiveSuffix);
        if (!"-".equals(this.negativePrefix) || !"".equals(this.negativeSuffix)) {
            buf.append(dfs.getPatternSeparator());
            buf.append(this.negativePrefix);
            buf.append(format);
            buf.append(this.negativeSuffix);
        }
        return buf.toString();
    }

    private void addChars(char digit, int size, StringBuffer buf) {
        for (int i = 0; i < size; ++i) {
            buf.append(digit);
        }
    }

    private void applyPattern(String pattern, DecimalFormatSymbols dfs) {
        String specials = this.dfsToString(dfs);
        StringBuffer buf = new StringBuffer();
        int pos = this.locateString(0, pattern, specials, buf);
        this.positivePrefix = buf.toString();
        pos = this.locateIntegerPart(pos, pattern, true, dfs);
        pos = this.locateFractionPart(pos, pattern, true, dfs);
        buf.setLength(0);
        if (pos < pattern.length()) {
            char ch = pattern.charAt(pos);
            if (ch == dfs.getPercent()) {
                this.multiplier = 100;
                buf.append(ch);
                ++pos;
            } else if (ch == dfs.getPerMill()) {
                this.multiplier = 1000;
                buf.append(ch);
                ++pos;
            } else {
                this.multiplier = 1;
                pos = this.locateString(pos, pattern, specials, buf);
            }
            this.positiveSuffix = buf.toString();
            if (pos < pattern.length() && pattern.charAt(pos) == dfs.getPatternSeparator()) {
                ++pos;
                buf.setLength(0);
                pos = this.locateString(pos, pattern, specials, buf);
                this.negativePrefix = buf.toString();
                pos = this.locateIntegerPart(pos, pattern, false, dfs);
                pos = this.locateFractionPart(pos, pattern, false, dfs);
                buf.setLength(0);
                pos = this.locateString(pos, pattern, specials, buf);
                this.negativeSuffix = this.multiplier > 1 ? this.positiveSuffix : buf.toString();
            } else {
                if (this.multiplier > 1) {
                    this.negativeSuffix = this.positiveSuffix;
                }
                this.negativePrefix = "-";
            }
        } else {
            this.negativeSuffix = this.positiveSuffix = "";
            this.negativePrefix = "-";
            this.multiplier = 1;
        }
    }

    private int locateString(int start, String pattern, String specials, StringBuffer buf) {
        int stop = pattern.length();
        for (int i = start; i < stop; ++i) {
            char ch = pattern.charAt(i);
            if (ch == '\'') {
                if (i + 2 >= stop || pattern.charAt(i + 2) != '\'') continue;
                buf.append(pattern.charAt(i + 1));
                i += 2;
                continue;
            }
            if (specials.indexOf(ch) != -1) {
                return i;
            }
            buf.append(ch);
        }
        return stop;
    }

    private int locateIntegerPart(int start, String pattern, boolean set, DecimalFormatSymbols dfs) {
        int min = 0;
        int size = -1;
        int stop = pattern.length();
        char digit = dfs.getDigit();
        char zero = dfs.getZeroDigit();
        char group = dfs.getGroupingSeparator();
        for (int i = start; i < stop; ++i) {
            char ch = pattern.charAt(i);
            if (ch == digit) {
                if (min > 0) {
                    throw new IllegalArgumentException("bad pattern");
                }
            } else if (ch == zero) {
                ++min;
            } else {
                if (ch == group) {
                    size = 0;
                    continue;
                }
                stop = i;
            }
            if (size == -1) continue;
            if (stop != i) {
                ++size;
                continue;
            }
            if (size != 0) continue;
            throw new IllegalArgumentException("bad pattern");
        }
        if (set) {
            this.setMinimumIntegerDigits(min);
            if (size != -1) {
                this.setGroupingUsed(true);
                this.groupingSize = (byte)size;
                if (this.groupingSize < 0) {
                    this.groupingSize = (byte)127;
                }
            } else {
                this.setGroupingUsed(false);
                this.groupingSize = 0;
            }
        }
        return stop;
    }

    private int locateFractionPart(int start, String pattern, boolean set, DecimalFormatSymbols dfs) {
        int stop = pattern.length();
        if (start >= stop || pattern.charAt(start) != dfs.getDecimalSeparator()) {
            if (set) {
                super.setMaximumFractionDigits(0);
                this.decimalSeparatorAlwaysShown = false;
            }
            return start;
        }
        int min = 0;
        int digits = 0;
        char digit = dfs.getDigit();
        char zero = dfs.getZeroDigit();
        for (int i = start + 1; i < stop; ++i) {
            char ch = pattern.charAt(i);
            if (ch == digit) {
                ++digits;
                continue;
            }
            if (ch == zero) {
                if (digits > 0) {
                    throw new IllegalArgumentException("bad pattern");
                }
                ++min;
                continue;
            }
            stop = i;
        }
        if (set) {
            this.setMinimumFractionDigits(min);
            this.setMaximumFractionDigits(min + digits);
            this.decimalSeparatorAlwaysShown = min > 0;
        }
        return stop;
    }

    private String dfsToString(DecimalFormatSymbols dfs) {
        StringBuffer buf = new StringBuffer();
        buf.append(dfs.getDigit());
        buf.append(dfs.getZeroDigit());
        buf.append(dfs.getDecimalSeparator());
        buf.append(dfs.getGroupingSeparator());
        buf.append(dfs.getPatternSeparator());
        buf.append(dfs.getPercent());
        buf.append(dfs.getPerMill());
        return buf.toString();
    }

    void debug(String pattern) {
        System.out.println("applied '" + pattern + "' on " + this.toString() + "\ndecimalSeparatorAlwaysShown " + this.decimalSeparatorAlwaysShown + "\ngroupingSize " + this.groupingSize + "\nmultiplier " + this.multiplier + "\nnegativePrefix " + this.negativePrefix + "\nnegativeSuffix " + this.negativeSuffix + "\npositivePrefix " + this.positivePrefix + "\npositiveSuffix " + this.positiveSuffix + "\nDecimalFormatSymbols " + this.dfsToString(this.symbols) + "\nuseExponentialNotation " + this.useExponentialNotation + "\ngetMaximumFractionDigits " + this.getMaximumFractionDigits() + "\ngetMinimumFractionDigits " + this.getMinimumFractionDigits() + "\ngetMaximumIntegerDigits " + this.getMaximumIntegerDigits() + "\ngetMinimumIntegerDigits " + this.getMinimumIntegerDigits());
    }
}

