/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.Serializable;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class DateFormatSymbols
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5987973545549424702L;
    private String[] ampms;
    private String[] eras;
    private String localPatternChars;
    private String[] months;
    private String[] shortMonths;
    private String[] shortWeekdays;
    private String[] weekdays;
    private String[][] zoneStrings;

    public DateFormatSymbols() {
        this(Locale.getDefault());
    }

    public DateFormatSymbols(Locale loc) {
        ResourceBundle resource = ResourceBundle.getBundle("com.acunia.resource.DateFormatSymbolBundle", loc);
        this.ampms = (String[])resource.getObject("ampms");
        this.eras = (String[])resource.getObject("eras");
        this.localPatternChars = (String)resource.getObject("pattern");
        this.months = (String[])resource.getObject("months");
        this.shortMonths = (String[])resource.getObject("shortMonths");
        this.shortWeekdays = (String[])resource.getObject("shortDays");
        this.weekdays = (String[])resource.getObject("days");
        this.zoneStrings = (String[][])resource.getObject("zones");
    }

    public Object clone() {
        try {
            DateFormatSymbols clone = (DateFormatSymbols)super.clone();
            clone.ampms = (String[])this.ampms.clone();
            clone.eras = (String[])this.eras.clone();
            clone.months = (String[])this.months.clone();
            clone.shortMonths = (String[])this.shortMonths.clone();
            clone.shortWeekdays = (String[])this.shortWeekdays.clone();
            clone.weekdays = (String[])this.weekdays.clone();
            clone.zoneStrings = (String[][])this.zoneStrings.clone();
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DateFormatSymbols)) {
            return false;
        }
        DateFormatSymbols dfs = (DateFormatSymbols)o;
        return Arrays.equals(this.ampms, dfs.ampms) && Arrays.equals(this.eras, dfs.eras) && Arrays.equals(this.months, dfs.months) && Arrays.equals(this.shortMonths, dfs.shortMonths) && Arrays.equals(this.shortWeekdays, dfs.shortWeekdays) && Arrays.equals(this.weekdays, dfs.weekdays) && Arrays.equals((Object[])this.zoneStrings, (Object[])dfs.zoneStrings) && this.localPatternChars.equals(dfs.localPatternChars);
    }

    public int hashCode() {
        return this.localPatternChars.hashCode() ^ this.zoneStrings.length;
    }

    public String[] getAmPmStrings() {
        return this.ampms;
    }

    public String[] getEras() {
        return this.eras;
    }

    public String getLocalPatternChars() {
        return this.localPatternChars;
    }

    public String[] getMonths() {
        return this.months;
    }

    public String[] getShortMonths() {
        return this.shortMonths;
    }

    public String[] getShortWeekdays() {
        return this.shortWeekdays;
    }

    public String[] getWeekdays() {
        return this.weekdays;
    }

    public String[][] getZoneStrings() {
        return this.zoneStrings;
    }

    public void setAmPmStrings(String[] val) {
        this.ampms = val;
    }

    public void setEras(String[] val) {
        this.eras = val;
    }

    public void setLocalPatternChars(String val) {
        this.localPatternChars = val;
    }

    public void setMonths(String[] val) {
        this.months = val;
    }

    public void setShortMonths(String[] val) {
        this.shortMonths = val;
    }

    public void setShortWeekdays(String[] val) {
        this.shortWeekdays = val;
    }

    public void setWeekdays(String[] val) {
        this.weekdays = val;
    }

    public void setZoneStrings(String[][] val) {
        this.zoneStrings = val;
    }

    String getTimeZoneString(Calendar cal, boolean longString) {
        TimeZone zone = cal.getTimeZone();
        String ID = zone.getID();
        for (int i = 0; i < this.zoneStrings.length; ++i) {
            if (!ID.equals(this.zoneStrings[i][0])) continue;
            int val = 1;
            val += longString ? 0 : 1;
            return this.zoneStrings[i][val += zone.inDaylightTime(cal.getTime()) ? 2 : 0];
        }
        return zone.getDisplayName(zone.inDaylightTime(cal.getTime()), longString ? 1 : 0);
    }

    int parseTimeZoneString(Calendar cal, boolean longString, String dest, ParsePosition pos) {
        int val = 1;
        int val2 = (val += longString ? 0 : 1) + 2;
        int start = pos.getIndex();
        for (int i = 0; i < this.zoneStrings.length; ++i) {
            if (dest.regionMatches(start, this.zoneStrings[i][val], 0, this.zoneStrings[i][val].length())) {
                cal.setTimeZone(TimeZone.getTimeZone(this.zoneStrings[i][0]));
                pos.setIndex(start + this.zoneStrings[i][val].length());
                return 1;
            }
            if (dest.regionMatches(start, this.zoneStrings[i][val2], 0, this.zoneStrings[i][val2].length())) {
                cal.setTimeZone(TimeZone.getTimeZone(this.zoneStrings[i][0]));
                pos.setIndex(start + this.zoneStrings[i][val2].length());
                return 0;
            }
            if (!dest.regionMatches(start, this.zoneStrings[i][0], 0, this.zoneStrings[i][0].length())) continue;
            cal.setTimeZone(TimeZone.getTimeZone(this.zoneStrings[i][0]));
            pos.setIndex(start + this.zoneStrings[i][0].length());
            return 0;
        }
        return -1;
    }
}

