/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.Serializable;
import java.text.CharacterIterator;
import java.text.SimpleBreakIterator;
import java.text.StringCharacterIterator;
import java.util.Locale;

public abstract class BreakIterator
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -7672886698079096632L;
    private static final String wordBreaks = " \r\t\n";
    private static final String sentenceBreaks = ".?!";
    private static final String lineBreaks = "\n\r";
    public static final int DONE = -1;

    public static synchronized Locale[] getAvailableLocales() {
        return new Locale[0];
    }

    public static BreakIterator getCharacterInstance() {
        return BreakIterator.getCharacterInstance(Locale.getDefault());
    }

    public static BreakIterator getCharacterInstance(Locale loc) {
        return new SimpleBreakIterator(null);
    }

    public static BreakIterator getLineInstance() {
        return BreakIterator.getLineInstance(Locale.getDefault());
    }

    public static BreakIterator getLineInstance(Locale loc) {
        return new SimpleBreakIterator(lineBreaks);
    }

    public static BreakIterator getSentenceInstance() {
        return BreakIterator.getSentenceInstance(Locale.getDefault());
    }

    public static BreakIterator getSentenceInstance(Locale loc) {
        return new SimpleBreakIterator(sentenceBreaks);
    }

    public static BreakIterator getWordInstance() {
        return BreakIterator.getWordInstance(Locale.getDefault());
    }

    public static BreakIterator getWordInstance(Locale loc) {
        return new SimpleBreakIterator(wordBreaks);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public abstract int current();

    public abstract int first();

    public abstract int following(int var1);

    public abstract CharacterIterator getText();

    public abstract int last();

    public abstract int next();

    public abstract int next(int var1);

    public abstract int previous();

    public abstract void setText(CharacterIterator var1);

    public boolean isBoundary(int pos) {
        CharacterIterator cit = this.getText();
        int old = cit.getIndex();
        cit.setIndex(pos);
        cit.next();
        char ret = cit.previous();
        cit.setIndex(old);
        boolean bl = false;
        if (ret == pos) {
            bl = true;
        }
        return bl;
    }

    public int preceding(int pos) {
        CharacterIterator cit = this.getText();
        int old = cit.getIndex();
        cit.setIndex(pos);
        char ret = cit.previous();
        cit.setIndex(old);
        return ret;
    }

    public void setText(String newText) {
        this.setText(new StringCharacterIterator(newText));
    }

    protected BreakIterator() {
    }
}

