/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class Timestamp
extends Date
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 2745179027874758501L;
    private int nanos;

    public boolean after(Timestamp ts) {
        boolean bl = false;
        if (this.getTime() * 1000000L + (long)this.nanos > ts.getTime() * 1000000L + (long)this.nanos) {
            bl = true;
        }
        return bl;
    }

    public boolean before(Timestamp ts) {
        boolean bl = false;
        if (this.getTime() * 1000000L + (long)this.nanos < ts.getTime() * 1000000L + (long)this.nanos) {
            bl = true;
        }
        return bl;
    }

    public boolean equals(Object ts) {
        if (ts instanceof Timestamp) {
            boolean bl = false;
            if (this.getTime() == ((Timestamp)ts).getTime() && this.nanos == ((Timestamp)ts).getNanos()) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public boolean equals(Timestamp ts) {
        boolean bl = false;
        if (this.getTime() == ts.getTime() && this.nanos == ts.getNanos()) {
            bl = true;
        }
        return bl;
    }

    public int getNanos() {
        return this.nanos;
    }

    public void setNanos(int n) {
        this.nanos = n;
    }

    public String toString() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        return "" + year + '-' + (month < 10 ? "0" + month : "" + month) + '-' + (day < 10 ? "0" + day : "" + day) + ' ' + (hour < 10 ? "0" + hour : "" + hour) + '-' + (min < 10 ? "0" + min : "" + min) + '-' + (sec < 10 ? "0" + (float)(sec + this.nanos / 1000000000) : "" + (float)(sec + this.nanos / 1000000000));
    }

    public static Timestamp valueOf(String s) {
        StringTokenizer tok = new StringTokenizer(s, " ");
        String date = tok.nextToken();
        String time = tok.nextToken();
        tok = new StringTokenizer(date, "-");
        int year = Integer.parseInt(tok.nextToken());
        int month = Integer.parseInt(tok.nextToken());
        int day = Integer.parseInt(tok.nextToken());
        tok = new StringTokenizer(time, ":");
        int hour = Integer.parseInt(tok.nextToken());
        int minute = Integer.parseInt(tok.nextToken());
        double second = Double.parseDouble(tok.nextToken());
        return new Timestamp(year, month, day, hour, minute, (int)Math.floor(second), (int)((second - Math.floor(second)) * 1.0E9));
    }

    public Timestamp(int year, int month, int date, int hour, int minute, int second, int nanos) {
        super(year, month, date, hour, minute, second);
        this.nanos = nanos;
    }

    public Timestamp(long time) {
        super(time - time % 1000L);
        this.nanos = (int)(time % 1000L) * 1000000;
    }
}

