/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class DriverManager {
    private static Vector drivers = new Vector();
    private static int loginTimeout;
    private static PrintStream outStream;
    private static PrintWriter outWriter;

    public static void registerDriver(Driver driver) throws SQLException {
        drivers.add(driver);
    }

    public static void deregisterDriver(Driver driver) throws SQLException {
        drivers.remove(driver);
    }

    public static Driver getDriver(String url) throws SQLException {
        Iterator iter = drivers.iterator();
        Driver result = null;
        while (iter.hasNext() && result == null) {
            Driver driver = (Driver)iter.next();
            if (!driver.acceptsURL(url)) continue;
            result = driver;
        }
        return result;
    }

    public static Enumeration getDrivers() {
        return drivers.elements();
    }

    public static Connection getConnection(String url) throws SQLException {
        return DriverManager.getConnection(url, null);
    }

    public static Connection getConnection(String url, Properties info) throws SQLException {
        Driver driver = DriverManager.getDriver(url);
        if (driver != null) {
            return driver.connect(url, info);
        }
        return null;
    }

    public static Connection getConnection(String url, String user, String password) throws SQLException {
        Properties p = new Properties();
        p.setProperty("user", user);
        p.setProperty("password", password);
        return DriverManager.getConnection(url, p);
    }

    public static int getLoginTimeout() {
        return loginTimeout;
    }

    public static void setLoginTimeout(int seconds) {
        loginTimeout = seconds;
    }

    public static PrintStream getLogStream() {
        return outStream;
    }

    public static void setLogStream(PrintStream out) {
        outStream = out;
    }

    public static PrintWriter getLogWriter() {
        return outWriter;
    }

    public static void setLogWriter(PrintWriter out) {
        outWriter = out;
    }

    public static void println(String message) {
        if (outWriter != null) {
            outWriter.println(message);
        } else {
            System.out.println(message);
        }
    }
}

