/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509Extension;
import java.util.Arrays;
import java.util.Date;

public abstract class X509CRLEntry
implements X509Extension {
    public boolean equals(Object other) {
        if (!(other instanceof X509CRLEntry)) {
            return false;
        }
        X509CRLEntry x509 = (X509CRLEntry)other;
        try {
            return Arrays.equals(x509.getEncoded(), this.getEncoded());
        }
        catch (CRLException e) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.getEncoded().hashCode();
        }
        catch (CRLException e) {
            return 0;
        }
    }

    public abstract byte[] getEncoded() throws CRLException;

    public abstract Date getRevocationDate();

    public abstract BigInteger getSerialNumber();

    public abstract boolean hasExtensions();

    public abstract String toString();
}

