/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.MessageDigestSpiWrapper;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecurityAction;
import java.util.Arrays;

public abstract class MessageDigest
extends MessageDigestSpi {
    private Provider provider;
    private String algorithm;

    public static boolean isEqual(byte[] first, byte[] second) {
        return Arrays.equals(first, second);
    }

    public static MessageDigest getInstance(String algorithm) throws NoSuchAlgorithmException {
        SecurityAction action = new SecurityAction(algorithm, "MessageDigest.");
        MessageDigest msgD = action.spi instanceof MessageDigest ? (MessageDigest)action.spi : new MessageDigestSpiWrapper((MessageDigestSpi)action.spi, algorithm);
        msgD.provider = action.provider;
        return msgD;
    }

    public static MessageDigest getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityAction action = new SecurityAction(algorithm, provider, "MessageDigest.");
        MessageDigest msgD = action.spi instanceof MessageDigest ? (MessageDigest)action.spi : new MessageDigestSpiWrapper((MessageDigestSpi)action.spi, algorithm);
        msgD.provider = action.provider;
        return msgD;
    }

    protected MessageDigest(String algorithm) {
        this.algorithm = algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void update(byte b) {
        this.engineUpdate(b);
    }

    public void update(byte[] bytes, int offset, int len) {
        this.engineUpdate(bytes, offset, len);
    }

    public void update(byte[] bytes) {
        this.engineUpdate(bytes, 0, bytes.length);
    }

    public byte[] digest() {
        return this.engineDigest();
    }

    public int digest(byte[] buf, int offset, int len) throws DigestException {
        return this.engineDigest(buf, offset, len);
    }

    public byte[] digest(byte[] bytes) {
        this.engineUpdate(bytes, 0, bytes.length);
        return this.engineDigest();
    }

    public String toString() {
        return "Message Digest based on " + this.algorithm + " and provided by " + this.provider;
    }

    public void reset() {
        this.engineReset();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getDigestLength() {
        try {
            return this.engineGetDigestLength();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

