/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.SocketPermission;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Vector;

public class CodeSource
implements Serializable {
    private static final long serialVersionUID = 4977541819976013951L;
    private URL url;
    private transient Certificate[] certs;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int l;
        in.defaultReadObject();
        if (l > 0) {
            this.certs = new Certificate[l];
            int i = 0;
            for (l = in.readInt(); i < l; ++l) {
                String type = (String)in.readObject();
                int s = in.readInt();
                try {
                    this.certs[i] = CertificateFactory.getInstance(type).generateCertificate(in);
                    continue;
                }
                catch (NoSuchAlgorithmException nsae) {
                    throw new IOException(nsae.toString());
                }
                catch (CertificateException ce) {
                    throw new IOException(ce.toString());
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int l = this.certs == null ? 0 : this.certs.length;
        out.writeInt(l);
        for (int i = 0; i < l; ++i) {
            Certificate cert = this.certs[i];
            out.writeObject(cert.getType());
            try {
                byte[] bytes = cert.getEncoded();
                out.writeInt(bytes.length);
                out.write(bytes);
                continue;
            }
            catch (CertificateEncodingException cee) {
                throw new IOException(cee.toString());
            }
        }
    }

    public CodeSource(URL url, Certificate[] certs) {
        this.url = url;
        this.certs = certs != null ? (Certificate[])certs.clone() : null;
    }

    public int hashCode() {
        int hash;
        int n = hash = this.url == null ? -12345 : this.url.hashCode();
        if (this.certs != null) {
            for (int i = 0; i < this.certs.length; ++i) {
                hash ^= this.certs[i].hashCode();
            }
        }
        return hash;
    }

    public boolean equals(Object obj) {
        boolean answer = false;
        if (obj instanceof CodeSource) {
            CodeSource target = (CodeSource)obj;
            if (this.url == null ? target.url == null : this.url.equals(target.url)) {
                Certificate[] targetcerts = target.getCertificates();
                if (this.certs == null || target.certs == null) {
                    return this.certs == target.certs;
                }
                if (this.certs.length == target.certs.length) {
                    Vector targets = new Vector(this.certs.length);
                    for (int i = 0; i < this.certs.length; ++i) {
                        targets.addElement(targetcerts[i]);
                    }
                    int found = 0;
                    for (int i = 0; i < this.certs.length && (found = targets.indexOf(this.certs[i])) >= 0; ++i) {
                        targets.removeElementAt(found);
                    }
                    answer = found >= 0;
                }
            }
        }
        return answer;
    }

    public final URL getLocation() {
        return this.url;
    }

    public final Certificate[] getCertificates() {
        return this.certs;
    }

    public boolean implies(CodeSource codesource) {
        if (codesource == null) {
            return false;
        }
        if (this.certs != null) {
            Certificate[] targetcerts = codesource.getCertificates();
            if (targetcerts == null) {
                return false;
            }
            Vector targets = new Vector(this.certs.length);
            for (int i = 0; i < this.certs.length; ++i) {
                targets.addElement(targetcerts[i]);
            }
            int found = 0;
            for (int i = 0; i < this.certs.length && (found = targets.indexOf(this.certs[i])) >= 0; ++i) {
                targets.removeElementAt(found);
            }
            if (found < 0) {
                return false;
            }
        }
        if (this.url != null) {
            String thatfile;
            if (codesource.url == null) {
                return false;
            }
            if (codesource.url == this.url) {
                return true;
            }
            if (!this.url.getProtocol().equals(codesource.url.getProtocol())) {
                return false;
            }
            String host = this.url.getHost();
            if (host != null && !new SocketPermission(host, "resolve").implies(new SocketPermission(codesource.url.getHost(), "resolve"))) {
                return false;
            }
            int port = this.url.getPort();
            if (port != -1 && port != codesource.url.getPort()) {
                return false;
            }
            String thisfile = this.url.getFile();
            if (!thisfile.equals(thatfile = codesource.url.getFile())) {
                String thisref;
                int slash = thisfile.lastIndexOf(47);
                int slashdash = thisfile.indexOf(45, slash);
                int slashstar = thisfile.indexOf(42, slash);
                if (slashdash == thisfile.length() - 1 && !thatfile.startsWith(thisfile.substring(0, slashdash))) {
                    return false;
                }
                if (slashstar == thisfile.length() - 1) {
                    int thatslash = thatfile.lastIndexOf(47);
                    if (!thatfile.startsWith(thisfile.substring(0, slashstar))) {
                        return false;
                    }
                    if (thatslash > slashstar) {
                        return false;
                    }
                } else {
                    if (slash == thisfile.length() - 1 && !thatfile.startsWith(thisfile)) {
                        return false;
                    }
                    if (slash != thisfile.length() - 1 && slashstar != thisfile.length() - 1 && slashdash != thisfile.length() - 1 && !thatfile.startsWith(thisfile + "/")) {
                        return false;
                    }
                }
                if ((thisref = this.url.getRef()) != null && thisref.equals(codesource.getLocation().getRef())) {
                    return false;
                }
            }
        }
        return true;
    }

    public String toString() {
        return this.url + " " + this.certs;
    }
}

