/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.Activator;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.RemoteRef;
import java.rmi.server.UID;

public class ActivationID
implements Serializable {
    private static final long serialVersionUID = -4608673054848209235L;
    private transient RemoteRef ref;
    private Activator activator;
    private UID uid;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.uid = (UID)in.readObject();
        String name = "com.acunia.wonka.rmi." + in.readUTF();
        try {
            this.ref = (RemoteRef)Class.forName(name).newInstance();
            this.ref.readExternal(in);
        }
        catch (NoSuchMethodException ie) {
            throw new MarshalException("no constructor with no arguments found for " + name);
        }
        catch (IllegalAccessException ie) {
            throw new MarshalException("no access for " + name);
        }
        catch (InstantiationException ie) {
            throw new MarshalException("failed to instantiate " + name);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        out.writeObject(this.uid);
        this.ref.getRefClass(out);
        this.ref.writeExternal(out);
    }

    public ActivationID(Activator activator) {
        this.activator = activator;
        this.uid = new UID();
    }

    public Remote activate(boolean force) throws ActivationException, UnknownObjectException, RemoteException {
        System.out.println("[ActivationID.activate] Not implemented...");
        return null;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this.getClass().isInstance(obj)) {
            ActivationID aid = (ActivationID)obj;
            return this.uid.equals(aid.uid) && this.activator.equals(aid.activator);
        }
        return false;
    }
}

