/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.acunia.wonka.net.DefaultContentHandlerFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.FileNameMap;
import java.net.URL;
import java.net.UnknownServiceException;
import java.security.AllPermission;
import java.security.Permission;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class URLConnection {
    private static boolean defaultAllowUserInteraction = false;
    private static boolean defaultUseCaches = false;
    private static FileNameMap fileNameMap = new DefaultFileNameMap();
    private static ContentHandlerFactory factory = null;
    protected boolean allowUserInteraction = defaultAllowUserInteraction;
    protected boolean connected;
    protected boolean doInput = true;
    protected boolean doOutput;
    protected boolean useCaches = defaultUseCaches;
    protected long ifModifiedSince;
    protected URL url;

    protected URLConnection(URL url) {
        this.url = url;
    }

    public abstract void connect() throws IOException;

    protected static String guessContentTypeFromName(String fname) {
        return fileNameMap.getContentTypeFor(fname);
    }

    public static boolean getDefaultAllowUserInteraction() {
        return defaultAllowUserInteraction;
    }

    public static FileNameMap getFileNameMap() {
        return fileNameMap;
    }

    public static void setContentHandlerFactory(ContentHandlerFactory fac) {
        if (fac == null) {
            throw new NullPointerException();
        }
        if (factory != null) {
            throw new Error();
        }
        factory = fac;
    }

    public static void setDefaultAllowUserInteraction(boolean defaultallowuserinteraction) {
        defaultAllowUserInteraction = defaultallowuserinteraction;
    }

    public static void setDefaultRequestProperty(String key, String value) {
    }

    public static void setFileNameMap(FileNameMap map) {
        if (map == null) {
            throw new NullPointerException();
        }
        fileNameMap = map;
    }

    public static String getDefaultRequestProperty(String key) {
        return null;
    }

    public boolean getAllowUserInteraction() {
        return this.allowUserInteraction;
    }

    public boolean getDoInput() {
        return this.doInput;
    }

    public boolean getDoOutput() {
        return this.doOutput;
    }

    public long getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public InputStream getInputStream() throws IOException {
        throw new UnknownServiceException();
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException();
    }

    public String getHeaderFieldKey(int n) {
        return null;
    }

    public String getHeaderField(int n) {
        return null;
    }

    public String getHeaderField(String name) {
        return null;
    }

    public long getDate() {
        return this.getHeaderFieldDate("Date", 0L);
    }

    public boolean getDefaultUseCaches() {
        return defaultUseCaches;
    }

    public long getExpiration() {
        return this.getHeaderFieldDate("Expires", 0L);
    }

    public long getLastModified() {
        return this.getHeaderFieldDate("Last-Modified", 0L);
    }

    public String getRequestProperty(String key) {
        return null;
    }

    public Permission getPermission() throws IOException {
        return new AllPermission();
    }

    public URL getURL() {
        return this.url;
    }

    public boolean getUseCaches() {
        return this.useCaches;
    }

    public void setAllowUserInteraction(boolean allowuserinteraction) {
        if (this.connected) {
            throw new IllegalAccessError("property cannot be set after connecting");
        }
        this.allowUserInteraction = allowuserinteraction;
    }

    public void setDefaultUseCaches(boolean defaultusecaches) {
        defaultUseCaches = defaultusecaches;
    }

    public void setDoInput(boolean doinput) {
        if (this.connected) {
            throw new IllegalAccessError("property cannot be set after connecting");
        }
        this.doInput = doinput;
    }

    public void setDoOutput(boolean dooutput) {
        if (this.connected) {
            throw new IllegalAccessError("property cannot be set after connecting");
        }
        this.doOutput = dooutput;
    }

    public void setIfModifiedSince(long ifmodifiedsince) {
        if (this.connected) {
            throw new IllegalAccessError("property cannot be set after connecting");
        }
        this.ifModifiedSince = ifmodifiedsince;
    }

    public void setUseCaches(boolean usecaches) {
        if (this.connected) {
            throw new IllegalAccessError("property cannot be set after connecting");
        }
        this.useCaches = usecaches;
    }

    public void setRequestProperty(String key, String value) {
    }

    public String toString() {
        return "connecting to " + this.url.toString() + " using " + this.getClass().getName();
    }

    public long getHeaderFieldDate(String name, long Default) {
        try {
            return Long.parseLong(this.getHeaderField(name));
        }
        catch (RuntimeException e) {
            return Default;
        }
    }

    public int getHeaderFieldInt(String name, int Default) {
        try {
            return Integer.parseInt(this.getHeaderField(name));
        }
        catch (RuntimeException e) {
            return Default;
        }
    }

    public String getContentEncoding() {
        return this.getHeaderField("Content-Encoding");
    }

    public int getContentLength() {
        return this.getHeaderFieldInt("Content-Length", -1);
    }

    public String getContentType() {
        return this.getHeaderField("Content-Type");
    }

    public static String guessContentTypeFromStream(InputStream is) {
        return null;
    }

    public Object getContent() throws IOException {
        ContentHandler cth;
        String ct = this.getContentType();
        if (ct == null && (ct = URLConnection.guessContentTypeFromName(this.url.getFile())) == null && (ct = URLConnection.guessContentTypeFromStream(new BufferedInputStream(this.getInputStream()))) == null) {
            return null;
        }
        if (factory != null && (cth = factory.createContentHandler(ct)) != null) {
            return cth.getContent(this);
        }
        cth = new DefaultContentHandlerFactory().createContentHandler(ct);
        if (cth != null) {
            return cth.getContent(this);
        }
        return null;
    }

    public Object getContent(Class[] classes) throws IOException {
        ContentHandler cth;
        String ct = this.getContentType();
        if (ct == null && (ct = URLConnection.guessContentTypeFromName(this.url.getFile())) == null) {
            try {
                ct = URLConnection.guessContentTypeFromStream(new BufferedInputStream(this.getInputStream()));
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (ct == null) {
                return null;
            }
        }
        if (factory != null && (cth = factory.createContentHandler(ct)) != null) {
            return cth.getContent(this, classes);
        }
        return null;
    }

    private static class DefaultFileNameMap
    implements FileNameMap {
        private ResourceBundle filenameMap;

        public DefaultFileNameMap() {
            try {
                this.filenameMap = ResourceBundle.getBundle("com.acunia.wonka.net.MimeTypeMap");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }

        public String getContentTypeFor(String fileName) {
            if (this.filenameMap != null) {
                return this.filenameMap.getString(fileName);
            }
            return null;
        }
    }
}

