/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.PlainSocketImpl;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;

public class ServerSocket {
    private static SocketImplFactory factory;
    private SocketImpl socket;
    private InetAddress local;

    public ServerSocket(int port) throws IOException {
        this(port, 50, null);
    }

    public ServerSocket(int port, int backlog) throws IOException {
        this(port, backlog, null);
    }

    public ServerSocket(int port, int backlog, InetAddress local) throws IOException {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException();
        }
        InetAddress.listenCheck(port);
        if (local == null) {
            local = InetAddress.allZeroAddress;
        }
        this.local = local;
        this.socket = factory == null ? new PlainSocketImpl() : factory.createSocketImpl();
        this.socket.create(true);
        this.socket.bind(local, port);
        this.socket.listen(backlog);
    }

    public Socket accept() throws IOException {
        Socket s = new Socket();
        this.implAccept(s);
        InetAddress.acceptCheck(s.getInetAddress().getHostAddress(), s.getPort());
        return s;
    }

    protected final void implAccept(Socket s) throws IOException {
        this.socket.accept(s.socket);
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public InetAddress getInetAddress() {
        return this.local;
    }

    public int getLocalPort() {
        return this.socket.localport;
    }

    public synchronized int getSoTimeout() throws SocketException {
        return (Integer)this.socket.getOption(4102);
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (timeout < 0) {
            throw new IllegalArgumentException();
        }
        this.socket.setOption(4102, new Integer(timeout));
    }

    public static synchronized void setSocketFactory(SocketImplFactory fact) throws IOException {
        if (factory != null) {
            throw new SocketException("factory already set");
        }
        InetAddress.factoryCheck();
        factory = fact;
    }

    public String toString() {
        return "ServerSocket[address = " + this.local + "at port = " + this.socket.localport + "]";
    }
}

