/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

public class Modifier {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int SUPER = 32;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICT = 2048;

    public static boolean isPublic(int mod) {
        return (mod & 1) != 0;
    }

    public static boolean isPrivate(int mod) {
        return (mod & 2) != 0;
    }

    public static boolean isProtected(int mod) {
        return (mod & 4) != 0;
    }

    public static boolean isStatic(int mod) {
        return (mod & 8) != 0;
    }

    public static boolean isFinal(int mod) {
        return (mod & 0x10) != 0;
    }

    public static boolean isSynchronized(int mod) {
        return (mod & 0x20) != 0;
    }

    public static boolean isVolatile(int mod) {
        return (mod & 0x40) != 0;
    }

    public static boolean isTransient(int mod) {
        return (mod & 0x80) != 0;
    }

    public static boolean isAbstract(int mod) {
        return (mod & 0x400) != 0;
    }

    public static boolean isStrict(int mod) {
        return (mod & 0x800) != 0;
    }

    public static boolean isNative(int mod) {
        return (mod & 0x100) != 0;
    }

    public static boolean isInterface(int mod) {
        return (mod & 0x200) != 0;
    }

    public static String toString(int mod) {
        StringBuffer buf = new StringBuffer();
        if (Modifier.isPublic(mod)) {
            buf.append("public ");
        }
        if (Modifier.isProtected(mod)) {
            buf.append("protected ");
        }
        if (Modifier.isPrivate(mod)) {
            buf.append("private ");
        }
        if (Modifier.isAbstract(mod)) {
            buf.append("abstract ");
        }
        if (Modifier.isStatic(mod)) {
            buf.append("static ");
        }
        if (Modifier.isFinal(mod)) {
            buf.append("final ");
        }
        if (Modifier.isTransient(mod)) {
            buf.append("transient ");
        }
        if (Modifier.isVolatile(mod)) {
            buf.append("volatile ");
        }
        if (Modifier.isNative(mod)) {
            buf.append("native ");
        }
        if (Modifier.isSynchronized(mod)) {
            buf.append("synchronized ");
        }
        if (Modifier.isInterface(mod)) {
            buf.append("interface ");
        }
        if (Modifier.isStrict(mod)) {
            buf.append("strict ");
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }
}

