/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

public final class Method
extends AccessibleObject
implements Member {
    public native Class getDeclaringClass();

    public native String getName();

    public native int getModifiers();

    public native Class getReturnType();

    public native Class[] getParameterTypes();

    public native Class[] getExceptionTypes();

    public native boolean equals(Object var1);

    public String toString() {
        int i;
        StringBuffer result = new StringBuffer(100);
        result.append(Modifier.toString(this.getModifiers()));
        if (result.length() > 0) {
            result.append(' ');
        }
        result.append(Method.getClassName(this.getReturnType()));
        result.append(" ");
        result.append(Method.getClassName(this.getDeclaringClass()));
        result.append(".");
        result.append(this.getName());
        result.append("(");
        Class[] classes = this.getParameterTypes();
        int l = classes.length;
        for (i = 0; i < l; ++i) {
            result.append(Method.getClassName(classes[i]));
            result.append(",");
        }
        if (l != 0) {
            result.setLength(result.length() - 1);
        }
        result.append(")");
        classes = this.getExceptionTypes();
        l = classes.length;
        if (l != 0) {
            result.append(" throws ");
            for (i = 0; i < l; ++i) {
                result.append(Method.getClassName(classes[i]));
                result.append(",");
            }
            result.setLength(result.length() - 1);
        }
        return new String(result);
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getDeclaringClass().getName().hashCode();
    }

    public Object invoke(Object obj, Object[] args) throws NullPointerException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int modifiers = this.getModifiers();
        if (!Modifier.isStatic(modifiers)) {
            if (obj == null) {
                throw new NullPointerException();
            }
            if (!this.getDeclaringClass().isAssignableFrom(obj.getClass())) {
                throw new IllegalArgumentException();
            }
        }
        if (args == null) {
            args = new Object[]{};
        }
        return this.invoke0(obj, args);
    }

    public native Object invoke0(Object var1, Object[] var2) throws NullPointerException, IllegalArgumentException, IllegalAccessException, InvocationTargetException;

    static String getClassName(Class c) {
        if (c.isArray()) {
            Class nc = c.getComponentType();
            if (nc.isArray()) {
                return Method.getClassName(nc) + "[]";
            }
            return nc.getName() + "[]";
        }
        return c.getName();
    }
}

