/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.HashMap;
import java.util.Iterator;

public class Thread
implements Runnable {
    public static final int MIN_PRIORITY = 1;
    public static final int MAX_PRIORITY = 10;
    public static final int NORM_PRIORITY = 5;
    private String name;
    private boolean started;
    private boolean stopped;
    private Runnable runObject;
    private ThreadGroup parent;
    private ClassLoader context_classloader;
    private HashMap threadLocals;
    private Throwable thrown;
    private ClassLoader cl;

    private static void permissionCheck(String permission) {
    }

    public Thread(ThreadGroup group, Runnable runObject, String name) throws SecurityException, IllegalThreadStateException {
        SecurityManager sm = System.getSecurityManager();
        ThreadGroup parent = group == null ? (sm == null ? Thread.currentThread().getThreadGroup() : sm.getThreadGroup()) : group;
        this.parent = parent;
        if (parent.isDestroyed()) {
            throw new IllegalThreadStateException();
        }
        if (sm != null) {
            sm.checkAccess(parent);
        }
        this.runObject = runObject;
        this.inheritThreadLocals(Thread.currentThread());
        this.context_classloader = Thread.currentThread() == null ? null : Thread.currentThread().getContextClassLoader();
        this.create(parent, name, runObject);
    }

    public Thread(Runnable runObject, String name) {
        this(null, runObject, name);
    }

    public Thread(ThreadGroup group, Runnable runObject) throws SecurityException, IllegalThreadStateException {
        this(group, runObject, null);
    }

    public Thread(Runnable runObject) {
        this(null, runObject, null);
    }

    public Thread(ThreadGroup group, String name) throws SecurityException, IllegalThreadStateException {
        SecurityManager sm = System.getSecurityManager();
        ThreadGroup parent = group == null ? (sm == null ? Thread.currentThread().getThreadGroup() : sm.getThreadGroup()) : group;
        this.parent = parent;
        if (parent.isDestroyed()) {
            throw new IllegalThreadStateException();
        }
        if (sm != null) {
            sm.checkAccess(parent);
        }
        this.runObject = this;
        this.inheritThreadLocals(Thread.currentThread());
        this.context_classloader = Thread.currentThread() == null ? null : Thread.currentThread().getContextClassLoader();
        this.create(parent, name, null);
    }

    public Thread(String name) {
        this((ThreadGroup)null, name);
    }

    public Thread() {
        this((ThreadGroup)null, (String)null);
    }

    private native void create(ThreadGroup var1, String var2, Runnable var3);

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public void run() {
        if (this.runObject != this) {
            this.runObject.run();
        }
    }

    public final void checkAccess() throws SecurityException {
    }

    public native int countStackFrames();

    void _run() {
        block2: {
            try {
                this.runObject.run();
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) break block2;
                this.parent.uncaughtException(this, t);
            }
        }
        this.stopped = true;
    }

    public void destroy() {
        this.stop0(new ThreadDeath());
    }

    public static void dumpStack() {
        new Exception("Thread.dumpStack called").printStackTrace();
    }

    public static int enumerate(Thread[] threads) {
        return Thread.currentThread().getThreadGroup().enumerate(threads);
    }

    public String toString() {
        return "Thread[" + this.name + "," + this.getPriority() + "," + this.parent.getName() + "]";
    }

    public void start() throws IllegalThreadStateException {
        if (this.started) {
            if (this.stopped) {
                return;
            }
            throw new IllegalThreadStateException(this + " already active");
        }
        int retcode = this.start0();
        this.started = true;
        if (retcode != 0) {
            this.started = false;
            throw new InternalError("Could not start " + this + ", OSwald return code = " + retcode);
        }
    }

    public native int start0();

    public native void join0(long var1, int var3);

    public native void sleep0(long var1, int var3);

    private native void stop0(Throwable var1);

    public final synchronized void stop() throws SecurityException {
        this.checkAccess();
        this.stop0(new ThreadDeath());
    }

    public final void stop(Throwable thr) throws SecurityException, NullPointerException {
        this.checkAccess();
        if (thr == null) {
            throw new NullPointerException();
        }
        this.stop0(thr);
    }

    private final native void suspend0();

    private final native void resume0();

    public final void suspend() throws SecurityException {
        this.checkAccess();
        this.suspend0();
    }

    public final void resume() throws SecurityException {
        this.checkAccess();
        this.resume0();
    }

    public final native String getName();

    private final native void setName0(String var1);

    public final void setName(String name) throws SecurityException {
        this.checkAccess();
        if (name == null) {
            this.setName0("");
        } else {
            this.setName0(name);
        }
    }

    public final ThreadGroup getThreadGroup() {
        return this.parent;
    }

    public final native int getPriority();

    private final native void setPriority0(int var1);

    public final void setPriority(int newPriority) throws SecurityException, IllegalArgumentException {
        this.checkAccess();
        if (newPriority < 1 || newPriority > 10) {
            throw new IllegalArgumentException("priority " + newPriority + " not allowed");
        }
        if (this.parent != null) {
            newPriority = Math.min(newPriority, this.parent.getMaxPriority());
        }
        this.setPriority0(newPriority);
    }

    public final native boolean isDaemon();

    private final native void setDaemon0(boolean var1);

    public final void setDaemon(boolean on) throws SecurityException, IllegalThreadStateException {
        this.checkAccess();
        if (this.isAlive()) {
            throw new IllegalThreadStateException(this + "");
        }
        this.setDaemon0(on);
    }

    public final boolean isAlive() {
        return this.started && !this.stopped;
    }

    public final void join() throws InterruptedException {
        this.join(0L, 0);
    }

    public final void join(long millis) throws InterruptedException {
        this.join(millis, 0);
    }

    public final void join(long millis, int nanos) throws InterruptedException {
        if (!this.isAlive()) {
            return;
        }
        this.join0(millis, nanos);
    }

    public synchronized native void interrupt();

    public native boolean isInterrupted();

    public static synchronized native boolean interrupted();

    public static native Thread currentThread();

    public static native void yield();

    public static void sleep(long millis) throws InterruptedException {
        Thread.sleep(millis, 0);
    }

    public static void sleep(long millis, int nanos) throws InterruptedException {
        Thread.currentThread().sleep0(millis, nanos);
    }

    private void inheritThreadLocals(Thread t) {
        HashMap h = t.threadLocals;
        if (h == null) {
            return;
        }
        Iterator i = h.keySet().iterator();
        if (this.threadLocals == null) {
            this.threadLocals = new HashMap();
        }
        while (i.hasNext()) {
            try {
                InheritableThreadLocal ihl = (InheritableThreadLocal)i.next();
                this.threadLocals.put(ihl, t.threadLocals.get(ihl));
            }
            catch (ClassCastException x) {}
        }
    }

    void setThreadLocal(ThreadLocal tl, Object obj) {
        if (this.threadLocals == null) {
            this.threadLocals = new HashMap();
        }
        this.threadLocals.put(tl, obj);
    }

    Object getThreadLocal(ThreadLocal tl) {
        if (this.threadLocals == null) {
            this.threadLocals = new HashMap();
        }
        return this.threadLocals.get(tl);
    }

    void deleteThreadLocal(ThreadLocal tl) {
        if (this.threadLocals != null) {
            this.threadLocals.remove(tl);
        }
    }

    public ClassLoader getContextClassLoader() {
        ClassLoader caller = ClassLoader.getCallingClassLoader();
        if (caller != null && !caller.isDelegationAncestor(this.context_classloader)) {
            Thread.permissionCheck("getClassLoader");
        }
        if (this.context_classloader == null) {
            this.context_classloader = ClassLoader.getSystemClassLoader();
        }
        return this.context_classloader;
    }

    public void setContextClassLoader(ClassLoader cl) {
        ClassLoader caller = ClassLoader.getCallingClassLoader();
        if (caller != null) {
            if (this.context_classloader == null) {
                this.context_classloader = ClassLoader.getSystemClassLoader();
            }
            if (!caller.isDelegationAncestor(this.context_classloader)) {
                Thread.permissionCheck("setContextClassLoader");
            }
        }
        this.context_classloader = cl;
    }
}

