/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import java.util.Locale;
import wonka.decoders.Decoder;

public final class String
implements Serializable,
Comparable {
    private static final long serialVersionUID = -6849794470754667710L;
    public static final Comparator CASE_INSENSITIVE_ORDER = new CIComparator();
    private int hashCode;

    private native void create_empty();

    private native void create_String(String var1);

    private native void create_StringBuffer(StringBuffer var1);

    private native void create_char(char[] var1, int var2, int var3);

    private native void create_byte(byte[] var1, int var2, int var3, int var4);

    public String() {
        this.create_empty();
    }

    public String(String value) throws NullPointerException {
        this.create_String(value);
    }

    public String(StringBuffer value) throws NullPointerException {
        this.create_StringBuffer(value);
    }

    public String(byte[] value) throws NullPointerException {
        this.create_byte(value, 0, 0, value.length);
    }

    public String(byte[] value, int hibyte) throws NullPointerException {
        this.create_byte(value, hibyte, 0, value.length);
    }

    public String(byte[] value, int hibyte, int offset, int count) throws NullPointerException, ArrayIndexOutOfBoundsException {
        this.create_byte(value, hibyte, offset, count);
    }

    public String(byte[] value, int offset, int count) throws NullPointerException, ArrayIndexOutOfBoundsException {
        this.create_byte(value, 0, offset, count);
    }

    public String(char[] value) throws NullPointerException {
        this.create_char(value, 0, value.length);
    }

    public String(byte[] value, int offset, int length, String str) throws UnsupportedEncodingException {
        char[] chars = Decoder.get(str).bToC(value, offset, length);
        this.create_char(chars, 0, chars.length);
    }

    public String(byte[] value, String str) throws UnsupportedEncodingException {
        this(value, 0, value.length, str);
    }

    public String(char[] value, int offset, int count) throws NullPointerException, ArrayIndexOutOfBoundsException {
        this.create_char(value, offset, count);
    }

    public String toString() {
        return this;
    }

    public int compareTo(Object obj) throws ClassCastException {
        return this.compareTo((String)obj);
    }

    public int compareToIgnoreCase(String str) {
        return this.toUpperCase().toLowerCase().compareTo(str.toUpperCase().toLowerCase());
    }

    public native boolean equals(Object var1);

    public native boolean equalsIgnoreCase(String var1);

    public native int hashCode();

    public native int length();

    public native char charAt(int var1) throws StringIndexOutOfBoundsException;

    public native void getChars(int var1, int var2, char[] var3, int var4) throws NullPointerException, IndexOutOfBoundsException;

    private native byte[] getNativeBytes(boolean var1);

    public byte[] getBytes(String enc) throws UnsupportedEncodingException {
        Decoder decoder = Decoder.get(enc);
        if (decoder == Decoder.DEFAULT) {
            return this.getNativeBytes(false);
        }
        char[] chars = this.toCharArray();
        return decoder.cToB(chars, 0, chars.length);
    }

    public byte[] getBytes() {
        Decoder decoder = Decoder.getDefault(GetSystemProperty.FILE_ENCODING);
        if (decoder == Decoder.DEFAULT) {
            return this.getNativeBytes(false);
        }
        char[] chars = this.toCharArray();
        return decoder.cToB(chars, 0, chars.length);
    }

    public void getBytes(int srcBegin, int srcEnd, byte[] dst, int dstBegin) throws NullPointerException, ArrayIndexOutOfBoundsException {
        byte[] bytes = this.getNativeBytes(false);
        System.arraycopy(bytes, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public native char[] toCharArray();

    public native int compareTo(String var1) throws NullPointerException;

    public native boolean startsWith(String var1, int var2) throws NullPointerException;

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public native boolean endsWith(String var1) throws NullPointerException;

    public native String trim();

    public native String intern();

    public static String valueOf(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.toString();
    }

    public static String valueOf(char[] data) throws NullPointerException {
        return new String(data);
    }

    public static String valueOf(char[] data, int offset, int count) throws NullPointerException {
        return new String(data, offset, count);
    }

    public static String valueOf(boolean b) {
        if (b) {
            return new String("true");
        }
        return new String("false");
    }

    public static native String valueOf(char var0);

    public static String valueOf(int i) {
        return Integer.toString(i);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(long l) {
        return Long.toString(l);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public static String copyValueOf(char[] chars, int offset, int length) {
        return new String(chars, offset, length);
    }

    public static String copyValueOf(char[] chars) {
        return new String(chars, 0, chars.length);
    }

    public native int indexOf(int var1, int var2);

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public native int indexOf(String var1, int var2) throws NullPointerException;

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public native int lastIndexOf(int var1, int var2);

    public int lastIndexOf(int ch) {
        return this.lastIndexOf(ch, this.length());
    }

    public native int lastIndexOf(String var1, int var2) throws NullPointerException;

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.length());
    }

    public native String substring(int var1, int var2) throws IndexOutOfBoundsException;

    public String substring(int offset) {
        return this.substring(offset, this.length());
    }

    public native String concat(String var1) throws NullPointerException;

    public native String replace(char var1, char var2);

    public native String toLowerCase(Locale var1);

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public native String toUpperCase(Locale var1);

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public native boolean regionMatches(boolean var1, int var2, String var3, int var4, int var5) throws NullPointerException;

    public boolean regionMatches(int toffset, String other, int ooffset, int len) throws NullPointerException {
        return this.regionMatches(false, toffset, other, ooffset, len);
    }

    public static native char[] dumpall();

    static final class CIComparator
    implements Comparator {
        CIComparator() {
        }

        public boolean equals(Object o) {
            return o instanceof CIComparator;
        }

        public int compare(Object f, Object s) {
            return ((String)f).compareToIgnoreCase((String)s);
        }
    }
}

