/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.FileDescriptor;
import java.io.FilePermission;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.PropertyPermission;

public class SecurityManager {
    protected boolean inCheck = false;
    private static Class awtPermission;
    private static Constructor awtpCon;
    static /* synthetic */ Class class$java$lang$String;

    public void checkPermission(Permission perm) {
    }

    public void checkPermission(Permission perm, Object context) {
    }

    public Object getSecurityContext() {
        return AccessController.getContext();
    }

    public ThreadGroup getThreadGroup() {
        return Thread.currentThread().getThreadGroup();
    }

    protected native Class[] getClassContext();

    protected native Class[] getNonPrivilegedClassContext();

    protected int classDepth(String name) {
        System.err.println("SecurityManager method classDepth() is deprecated!");
        Class[] classes = this.getClassContext();
        try {
            Class cl = Class.forName(name);
            for (int i = 0; i < classes.length; ++i) {
                if (classes[i] != cl) continue;
                return i;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return -1;
    }

    protected ClassLoader currentClassLoader() {
        System.err.println("SecurityManager method currentClassLoader() is deprecated!");
        Class clc = this.currentLoadedClass();
        return clc == null ? null : clc.getClassLoader();
    }

    protected Class currentLoadedClass() {
        System.err.println("SecurityManager method currentLoadedClass() is deprecated!");
        Class[] classes = this.getNonPrivilegedClassContext();
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        try {
            this.inCheck = true;
            this.checkPermission(new AllPermission());
            this.inCheck = false;
            return null;
        }
        catch (SecurityException se) {
            this.inCheck = false;
            for (int i = 0; i < classes.length; ++i) {
                ClassLoader cl = classes[i].getClassLoader();
                if (cl == null || cl == scl) continue;
                return classes[i];
            }
            return null;
        }
    }

    protected int classLoaderDepth() {
        System.err.println("SecurityManager method classLoaderDepth() is deprecated!");
        if (this.currentLoadedClass() == null) {
            return -1;
        }
        Class[] classes = this.getNonPrivilegedClassContext();
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        try {
            this.inCheck = true;
            this.checkPermission(new AllPermission());
            this.inCheck = false;
            return -1;
        }
        catch (SecurityException se) {
            this.inCheck = false;
            for (int i = 0; i < classes.length; ++i) {
                ClassLoader cl = classes[i].getClassLoader();
                if (cl == null || cl == scl) continue;
                return i;
            }
            return -1;
        }
    }

    protected boolean inClass(String name) {
        System.err.println("SecurityManager method inClass() is deprecated!");
        return this.classDepth(name) >= 0;
    }

    protected boolean inClassLoader() {
        System.err.println("SecurityManager method inClassLoader() is deprecated!");
        return this.currentClassLoader() != null;
    }

    public synchronized boolean getInCheck() {
        System.err.println("SecurityManager method getInCheck() is deprecated!");
        return this.inCheck;
    }

    public void checkCreateClassLoader() throws SecurityException {
        this.inCheck = true;
        this.checkPermission(new RuntimePermission("createClassLoader"));
        this.inCheck = false;
    }

    public void checkAccess(Thread t) throws SecurityException {
        if (t.getThreadGroup().getParent() != null) {
            return;
        }
        this.inCheck = true;
        this.checkPermission(new RuntimePermission("modifyThread"));
        this.inCheck = false;
    }

    public void checkAccess(ThreadGroup g) throws SecurityException {
        if (g.getParent() != null) {
            return;
        }
        this.inCheck = true;
        this.checkPermission(new RuntimePermission("modifyThreadGroup"));
        this.inCheck = false;
    }

    public void checkMemberAccess(Class cl, int mtype) throws SecurityException {
        if (mtype != 0 && cl.getClassLoader() != this.currentClassLoader()) {
            this.inCheck = true;
            this.checkPermission(new RuntimePermission("accessDeclaredMembers." + cl.getName()));
            this.inCheck = false;
        }
    }

    public void checkExit(int status) throws SecurityException {
        this.inCheck = true;
        this.checkPermission(new RuntimePermission("exitVM"));
        this.inCheck = false;
    }

    public void checkExec(String cmd) throws SecurityException {
        this.inCheck = true;
        this.checkPermission(new FilePermission(cmd, "execute"));
        this.inCheck = false;
    }

    public void checkMulticast(InetAddress addr) throws SecurityException {
        this.inCheck = true;
        this.checkPermission(new SocketPermission(addr.getHostAddress(), "accept,connect"));
        this.inCheck = false;
    }

    public void checkMulticast(InetAddress addr, byte ttl) throws SecurityException {
        this.inCheck = true;
        this.checkPermission(new SocketPermission(addr.getHostAddress(), "accept,connect"));
        this.inCheck = false;
    }

    public void checkPropertyAccess(String propname) throws SecurityException {
        this.inCheck = true;
        this.checkPermission(new PropertyPermission(propname, "read"));
        this.inCheck = false;
    }

    public void checkPropertiesAccess() throws SecurityException {
        this.inCheck = true;
        this.checkPermission(new PropertyPermission("*", "read,write"));
        this.inCheck = false;
    }

    public void checkSecurityAccess(String target) throws SecurityException {
        this.inCheck = true;
        this.checkPermission(new SecurityPermission(target));
        this.inCheck = false;
    }

    public void checkLink(String libname) throws SecurityException {
        this.inCheck = true;
        this.checkPermission(new RuntimePermission("loadLibrary." + libname));
        this.inCheck = false;
    }

    public void checkRead(FileDescriptor fd) throws SecurityException {
        this.inCheck = true;
        this.checkPermission(new RuntimePermission("readFileDescriptor"));
        this.inCheck = false;
    }

    public void checkRead(String file) throws SecurityException {
        this.inCheck = true;
        this.checkPermission(new FilePermission(file, "read"));
        this.inCheck = false;
    }

    public void checkRead(String file, Object context) throws SecurityException {
        this.inCheck = true;
        this.checkPermission(new FilePermission(file, "read"), context);
        this.inCheck = false;
    }

    public void checkWrite(FileDescriptor fd) throws SecurityException {
        this.inCheck = true;
        this.checkPermission(new RuntimePermission("writeFileDescriptor"));
        this.inCheck = false;
    }

    public void checkWrite(String file) throws SecurityException {
        this.inCheck = true;
        this.checkPermission(new FilePermission(file, "write"));
        this.inCheck = false;
    }

    public void checkWrite(String file, Object context) throws SecurityException {
        this.inCheck = true;
        this.checkPermission(new FilePermission(file, "write"), context);
        this.inCheck = false;
    }

    public void checkDelete(String file) throws SecurityException {
        this.inCheck = true;
        this.checkPermission(new FilePermission(file, "delete"));
        this.inCheck = false;
    }

    public void checkConnect(String host, int port) throws SecurityException {
        this.inCheck = true;
        if (port == -1) {
            this.checkPermission(new SocketPermission(host, "resolve"));
        } else {
            this.checkPermission(new SocketPermission(host + ":" + port, "connect"));
        }
        this.inCheck = false;
    }

    public void checkConnect(String host, int port, Object context) throws SecurityException {
        this.inCheck = true;
        if (port == -1) {
            this.checkPermission(new SocketPermission(host, "resolve"), context);
        } else {
            this.checkPermission(new SocketPermission(host + ":" + port, "connect"), context);
        }
        this.inCheck = false;
    }

    public void checkListen(int port) throws SecurityException {
        this.inCheck = true;
        if (port == 0) {
            this.checkPermission(new SocketPermission("localhost:1024-", "listen"));
        } else {
            this.checkPermission(new SocketPermission("localhost:" + port, "listen"));
        }
        this.inCheck = false;
    }

    public void checkAccept(String host, int port) throws SecurityException {
        this.inCheck = true;
        this.checkPermission(new SocketPermission(host + ":" + port, "accept"));
        this.inCheck = false;
    }

    public void checkPrintJobAccess() throws SecurityException {
        Permission perm;
        if (awtPermission != null) {
            Object[] params = new Object[]{new String("queuePrintJob")};
            try {
                perm = (Permission)awtpCon.newInstance(params);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SecurityException("Failed to create an AWTPermission? " + e);
            }
        } else {
            throw new SecurityException("No AWT present?");
        }
        this.inCheck = true;
        this.checkPermission(perm);
        this.inCheck = false;
    }

    public void checkSystemClipboardAccess() throws SecurityException {
        Permission perm;
        if (awtPermission != null) {
            Object[] params = new Object[]{new String("accessClipboard")};
            try {
                perm = (Permission)awtpCon.newInstance(params);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SecurityException("Failed to create an AWTPermission? " + e);
            }
        } else {
            throw new SecurityException("No AWT present?");
        }
        this.inCheck = true;
        this.checkPermission(perm);
        this.inCheck = false;
    }

    public void checkAwtEventQueueAccess() throws SecurityException {
        Permission perm;
        if (awtPermission != null) {
            Object[] params = new Object[]{new String("accessEventQueue")};
            try {
                perm = (Permission)awtpCon.newInstance(params);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SecurityException("Failed to create an AWTPermission? " + e);
            }
        } else {
            throw new SecurityException("No AWT present?");
        }
        this.inCheck = true;
        this.checkPermission(perm);
        this.inCheck = false;
    }

    public void checkSetFactory() throws SecurityException {
        this.inCheck = true;
        this.checkPermission(new RuntimePermission("setFactory"));
        this.inCheck = false;
    }

    public boolean checkTopLevelWindow(Object window) throws SecurityException {
        if (awtPermission != null) {
            Permission perm;
            Object[] params = new Object[]{new String("topLevelWindowPermission")};
            try {
                perm = (Permission)awtpCon.newInstance(params);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            this.inCheck = true;
            try {
                this.checkPermission(perm);
                this.inCheck = false;
                return true;
            }
            catch (SecurityException se) {
                this.inCheck = false;
                return false;
            }
        }
        return false;
    }

    public void checkPackageAccess(String packageName) throws SecurityException {
        String arestricted;
        String restricteds = Security.getProperty("package.definition");
        if (restricteds == null) {
            System.err.println("Hm, we don't seem to have a security property `package.definition'.  This is broken, someone please fix it.");
            restricteds = "java,wonka,com.acunia.wonka";
        }
        int comma = restricteds.indexOf(44);
        this.inCheck = true;
        while (comma >= 0) {
            arestricted = restricteds.substring(0, comma);
            if (packageName == arestricted || packageName.startsWith(arestricted) && packageName.charAt(arestricted.length()) == '.') {
                this.checkPermission(new RuntimePermission("accessClassInPackage." + packageName));
            }
            restricteds = restricteds.substring(comma + 1);
            comma = restricteds.indexOf(44);
        }
        arestricted = restricteds;
        if (packageName == arestricted || packageName.startsWith(arestricted) && packageName.charAt(arestricted.length()) == '.') {
            this.checkPermission(new RuntimePermission("accessClassInPackage." + packageName));
        }
        this.inCheck = false;
    }

    public void checkPackageDefinition(String packageName) throws SecurityException {
        String arestricted;
        String restricteds = Security.getProperty("package.definition");
        if (restricteds == null) {
            System.err.println("Hm, we don't seem to have a security property `package.definition'.  This is broken, someone please fix it.");
        }
        int comma = restricteds.indexOf(44);
        this.inCheck = true;
        while (comma >= 0) {
            arestricted = restricteds.substring(0, comma);
            if (packageName == arestricted || packageName.startsWith(arestricted) && packageName.charAt(arestricted.length()) == '.') {
                this.checkPermission(new RuntimePermission("defineClassInPackage." + packageName));
                this.inCheck = true;
            }
            restricteds = restricteds.substring(comma + 1);
            comma = restricteds.indexOf(44);
        }
        arestricted = restricteds;
        if (packageName == arestricted || packageName.startsWith(arestricted) && packageName.charAt(arestricted.length()) == '.') {
            this.checkPermission(new RuntimePermission("defineClassInPackage." + packageName));
        }
        this.inCheck = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            awtPermission = Class.forName("java.awt.AWTPermission");
            Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SecurityManager.class$("java.lang.String")) : class$java$lang$String};
            awtpCon = awtPermission.getConstructor(params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

