/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Long
extends Number
implements Comparable {
    private static final long serialVersionUID = 4290774380558885855L;
    private final long value;
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class TYPE = Long.getWrappedClass();

    public Long(long value) {
        this.value = value;
    }

    public Long(String s) throws NumberFormatException {
        this(Long.parseLong(s));
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Long) {
            return this.value == (Long)obj;
        }
        return false;
    }

    public int compareTo(Long anotherLong) {
        long other = anotherLong;
        if (this.value == other) {
            return 0;
        }
        if (this.value < other) {
            return -1;
        }
        return 1;
    }

    public int compareTo(Object obj) throws ClassCastException {
        return this.compareTo((Long)obj);
    }

    public static Long decode(String s) throws NumberFormatException {
        boolean negative = false;
        int index = 0;
        int radix = 10;
        if (s.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (s.substring(index).equals("0")) {
            return new Long(0L);
        }
        if (s.substring(index).startsWith("0x")) {
            radix = 16;
            index += 2;
        } else if (s.substring(index).startsWith("#")) {
            radix = 16;
            ++index;
        } else if (s.substring(index).startsWith("0")) {
            radix = 8;
            ++index;
        }
        String magnitude = s.substring(index);
        if (magnitude.startsWith("-")) {
            throw new NumberFormatException("wrong position of sign");
        }
        return new Long(Long.parseLong((negative ? "-" : "") + magnitude, radix));
    }

    public static Long getLong(String nm) {
        return Long.getLong(nm, null);
    }

    public static Long getLong(String nm, long val) {
        Long result = Long.getLong(nm, null);
        if (result == null) {
            result = new Long(val);
        }
        return result;
    }

    public static Long getLong(String nm, Long val) {
        String property = System.getProperty(nm);
        if (property == null) {
            return val;
        }
        try {
            return Long.decode(property);
        }
        catch (NumberFormatException n) {
            return val;
        }
    }

    public static String toHexString(long j) {
        return Math.toStringUnsigned(j, 16);
    }

    public static String toOctalString(long j) {
        return Math.toStringUnsigned(j, 8);
    }

    public static String toBinaryString(long j) {
        return Math.toStringUnsigned(j, 2);
    }

    public String toString() {
        return Math.toString(this.value, 10);
    }

    public static String toString(long j) {
        return Math.toString(j, 10);
    }

    public static String toString(long j, int radix) {
        return Math.toString(j, radix);
    }

    public static long parseLong(String s, int radix) throws NumberFormatException {
        boolean negative;
        int index = 0;
        long result = 0L;
        if (s == null) {
            throw new NumberFormatException("cannot parse 'null'");
        }
        int length = s.length();
        if (length == 0) {
            throw new NumberFormatException("empty");
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("bad radix");
        }
        if (s.charAt(0) == '-') {
            if (length == 1) {
                throw new NumberFormatException("just minus");
            }
            negative = true;
            ++index;
        } else {
            negative = false;
        }
        long div = Long.MIN_VALUE / (long)radix;
        long mod = -(Long.MIN_VALUE % (long)radix);
        while (index < length) {
            int digit = Character.digit(s.charAt(index), radix);
            if (digit < 0) {
                throw new NumberFormatException("bad digit");
            }
            if (result <= div && (result < div || (long)digit > mod)) {
                throw new NumberFormatException("too big");
            }
            result = result * (long)radix - (long)digit;
            ++index;
        }
        if (negative) {
            return result;
        }
        if (result == Long.MIN_VALUE) {
            throw new NumberFormatException("too big");
        }
        return -result;
    }

    public static long parseLong(String s) throws NumberFormatException {
        return Long.parseLong(s, 10);
    }

    public static Long valueOf(String s, int radix) throws NumberFormatException {
        return new Long(Long.parseLong(s, radix));
    }

    public static Long valueOf(String s) throws NumberFormatException {
        return new Long(Long.parseLong(s, 10));
    }

    private static native Class getWrappedClass();
}

