/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Integer
extends Number
implements Comparable {
    private static final long serialVersionUID = 1360826667806852920L;
    private final int value;
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final Class TYPE = Integer.getWrappedClass();

    public Integer(int value) {
        this.value = value;
    }

    public Integer(String s) throws NumberFormatException {
        this.value = Integer.parseInt(s, 10);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Integer) {
            return this.value == ((Integer)obj).value;
        }
        return false;
    }

    public int compareTo(Integer anotherInteger) {
        int other = anotherInteger.value;
        if (this.value == other) {
            return 0;
        }
        if (this.value < other) {
            return -1;
        }
        return 1;
    }

    public int compareTo(Object obj) throws ClassCastException {
        return this.compareTo((Integer)obj);
    }

    public int intValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public static String toHexString(int i) {
        return Math.toStringUnsigned(i, 16);
    }

    public static String toOctalString(int i) {
        return Math.toStringUnsigned(i, 8);
    }

    public static String toBinaryString(int i) {
        return Math.toStringUnsigned(i, 2);
    }

    public String toString() {
        return Math.toString(this.value, 10);
    }

    public static int parseInt(String s, int radix) throws NumberFormatException {
        long l = Long.parseLong(s, radix);
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new NumberFormatException();
        }
        return (int)l;
    }

    public static int parseInt(String s) throws NumberFormatException {
        return Integer.parseInt(s, 10);
    }

    public static Integer valueOf(String s, int radix) throws NumberFormatException {
        return new Integer(Integer.parseInt(s, radix));
    }

    public static Integer valueOf(String s) throws NumberFormatException {
        return new Integer(Integer.parseInt(s, 10));
    }

    public static Integer decode(String s) throws NumberFormatException {
        boolean negative = false;
        int index = 0;
        int radix = 10;
        boolean result = false;
        if (s.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (s.substring(index).equals("0")) {
            return new Integer(0);
        }
        if (s.substring(index).startsWith("0x") || s.substring(index).startsWith("0X")) {
            radix = 16;
            index += 2;
        } else if (s.substring(index).startsWith("#")) {
            radix = 16;
            ++index;
        } else if (s.substring(index).startsWith("0")) {
            radix = 8;
            ++index;
        }
        String magnitude = s.substring(index);
        if (magnitude.startsWith("-")) {
            throw new NumberFormatException("wrong position of sign");
        }
        return new Integer(Integer.parseInt((negative ? "-" : "") + magnitude, radix));
    }

    public static String toString(int i) {
        return Math.toString(i, 10);
    }

    public static String toString(int i, int radix) {
        return Math.toString(i, radix);
    }

    public static Integer getInteger(String nm) {
        return Integer.getInteger(nm, null);
    }

    public static Integer getInteger(String nm, int val) {
        Integer result = Integer.getInteger(nm, null);
        if (result == null) {
            result = new Integer(val);
        }
        return result;
    }

    public static Integer getInteger(String nm, Integer val) {
        String property = System.getProperty(nm);
        if (property == null) {
            return val;
        }
        try {
            return Integer.decode(property);
        }
        catch (NumberFormatException e) {
            return val;
        }
    }

    private static native Class getWrappedClass();
}

