/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public class SequenceInputStream
extends InputStream {
    Enumeration seq;
    InputStream first;
    InputStream second;

    public int read() throws IOException {
        int readresult = -1;
        if (this.first != null && (readresult = this.first.read()) < 0) {
            this.first = null;
        }
        if (readresult < 0 && this.second != null && (readresult = this.second.read()) < 0) {
            this.second = null;
        }
        if (readresult < 0 && this.seq != null && this.seq.hasMoreElements()) {
            InputStream next = (InputStream)this.seq.nextElement();
            readresult = next.read();
        }
        return readresult;
    }

    public int read(byte[] b, int off, int len) throws IOException, NullPointerException, ArrayIndexOutOfBoundsException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int i = 0;
        while (i < len) {
            int nextbyte = this.read();
            if (nextbyte < 0) {
                return -1;
            }
            b[i + off] = (byte)nextbyte;
            ++i;
        }
        return i;
    }

    public void close() throws IOException {
        if (this.seq != null) {
            while (this.seq.hasMoreElements()) {
                ((InputStream)this.seq.nextElement()).close();
            }
            this.seq = null;
        }
        if (this.first != null) {
            this.first.close();
            this.first = null;
        }
        if (this.second != null) {
            this.second.close();
            this.second = null;
        }
    }

    public int available() throws IOException {
        return 0;
    }

    public SequenceInputStream(Enumeration e) {
        this.seq = e;
    }

    public SequenceInputStream(InputStream s1, InputStream s2) {
        this.first = s1;
        this.second = s2;
    }
}

