/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class PushbackReader
extends FilterReader {
    private int pos;
    private char[] chars;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.chars != null) {
                this.in.close();
            }
            return;
        }
    }

    public void mark(int ignored) throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.chars == null) {
                throw new IOException("Reader is closed");
            }
            if (this.pos < this.chars.length) {
                return this.chars[this.pos++];
            }
            return this.in.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(char[] buf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.chars == null) {
                throw new IOException("Reader is closed");
            }
            if (buf.length < off + len || off < 0 || len < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int rd = this.chars.length - this.pos;
            if (rd > 0) {
                if (len <= rd) {
                    System.arraycopy(this.chars, this.pos, buf, off, rd);
                    this.pos += len;
                    return len;
                }
                System.arraycopy(this.chars, this.pos, buf, off, rd);
                off += rd;
                this.pos += rd;
                len -= rd;
            }
            return (len = this.in.read(buf, off, len)) == -1 ? (rd == 0 ? len : rd) : len + rd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.chars == null) {
                throw new IOException("Reader is closed");
            }
            boolean bl = false;
            if (this.pos < this.chars.length) return true;
            if (!this.in.ready()) return bl;
            return true;
        }
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unread(int ch) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.chars != null && this.pos != 0) {
                this.chars[--this.pos] = (char)ch;
                return;
            }
            throw new IOException();
        }
    }

    public void unread(char[] buf) throws IOException {
        this.unread(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unread(char[] buf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (buf.length < off + len || off < 0 || len < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (this.chars == null) {
                throw new IOException("char array is null");
            }
            if (this.pos - len < 0) {
                throw new IOException("PushbackBuffer is full");
            }
            this.pos -= len;
            System.arraycopy(buf, off, this.chars, this.pos, len);
            return;
        }
    }

    public PushbackReader(Reader in) {
        super(in);
        this.chars = new char[1];
        this.pos = 1;
    }

    public PushbackReader(Reader in, int size) {
        super(in);
        if (size < 1) {
            throw new IllegalArgumentException("buffer size should 1 or greater");
        }
        this.chars = new char[size];
        this.pos = size;
    }
}

