/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.GetSystemProperty;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class PrintWriter
extends Writer {
    private boolean autoF;
    private boolean error = false;
    private boolean closed = false;
    private static final String line_separator = GetSystemProperty.LINE_SEPARATOR;
    protected Writer out;

    public PrintWriter(OutputStream out) {
        this(out, false);
    }

    public PrintWriter(OutputStream out, boolean autoFlush) {
        super(out);
        this.out = new OutputStreamWriter(out);
        this.autoF = autoFlush;
    }

    public PrintWriter(Writer out) {
        this(out, false);
    }

    public PrintWriter(Writer out, boolean autoFlush) {
        super(out);
        this.out = out;
        this.autoF = autoFlush;
    }

    public boolean checkError() {
        this.flush();
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                try {
                    this.out.close();
                }
                catch (IOException ioe) {
                    this.error = true;
                }
                this.closed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.out.flush();
            }
            catch (IOException ioe) {
                this.error = true;
            }
        }
    }

    public void print(boolean b) {
        this.write(String.valueOf(b));
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(char[] s) {
        this.write(s, 0, s.length);
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(int i) {
        this.write(String.valueOf(i));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(Object obj) {
        this.write(obj == null ? "null" : obj.toString());
    }

    public void print(String s) {
        this.write(s == null ? "null" : s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println() {
        Object object = this.lock;
        synchronized (object) {
            this.write(line_separator);
            if (this.autoF) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean b) {
        Object object = this.lock;
        synchronized (object) {
            this.print(b);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char c) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.out.write(c);
                this.println();
            }
            catch (IOException ioe) {
                this.error = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] c) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.out.write(c);
                this.println();
            }
            catch (IOException ioe) {
                this.error = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double d) {
        Object object = this.lock;
        synchronized (object) {
            this.print(d);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float f) {
        Object object = this.lock;
        synchronized (object) {
            this.print(f);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int i) {
        Object object = this.lock;
        synchronized (object) {
            this.print(i);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long l) {
        Object object = this.lock;
        synchronized (object) {
            this.print(l);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object obj) {
        Object object = this.lock;
        synchronized (object) {
            this.print(obj);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String s) {
        Object object = this.lock;
        synchronized (object) {
            this.print(s);
            this.println();
        }
    }

    protected void setError() {
        this.error = true;
    }

    public void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf, int off, int len) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.out.write(buf, off, len);
            }
        }
        catch (IOException ioe) {
            this.error = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int ch) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.out.write(ch);
            }
        }
        catch (IOException ioe) {
            this.error = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.out.write(s, 0, s.length());
            }
        }
        catch (IOException ioe) {
            this.error = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s, int off, int len) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.out.write(s, off, len);
            }
        }
        catch (IOException ioe) {
            this.error = true;
        }
    }
}

