/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterOutputStream;
import java.io.GetSystemProperty;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class PrintStream
extends FilterOutputStream {
    private static final String line_separator = GetSystemProperty.LINE_SEPARATOR;
    private static final byte[] newline_bytes = line_separator.getBytes();
    private boolean caughtException;
    private boolean closed;
    private boolean autoFlush;

    public PrintStream(OutputStream outputstream) {
        super(outputstream);
        if (outputstream == null) {
            throw new NullPointerException();
        }
    }

    public PrintStream(OutputStream outputstream, boolean autoflush) {
        super(outputstream);
        if (outputstream == null) {
            throw new NullPointerException();
        }
        this.autoFlush = autoflush;
    }

    public synchronized void write(int b) {
        try {
            this.out.write(b);
            if ((char)b == '\n' && this.autoFlush) {
                this.flush();
            }
        }
        catch (IOException e) {
            if (e instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            this.caughtException = true;
        }
    }

    public synchronized void write(byte[] b, int off, int len) throws NullPointerException, ArrayIndexOutOfBoundsException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.internalwrite(b, off, len);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void close() {
        if (!this.closed) {
            this.flush();
            try {
                this.closed = true;
                this.out.close();
            }
            catch (IOException e) {
                if (e instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                this.caughtException = true;
            }
        }
    }

    public synchronized void flush() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            if (e instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            this.caughtException = true;
        }
    }

    protected void setError() {
        this.caughtException = true;
    }

    public boolean checkError() {
        return this.caughtException;
    }

    private synchronized void internalwrite(byte[] b, int off, int count) {
        try {
            this.out.write(b, off, count);
        }
        catch (IOException e) {
            if (e instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            this.caughtException = true;
        }
    }

    public void print(Object obj) {
        this.print(String.valueOf(obj));
    }

    public void print(String s) {
        if (s == null) {
            this.print("null");
        } else {
            try {
                byte[] b = s.getBytes();
                this.internalwrite(b, 0, b.length);
                if (this.autoFlush && s.lastIndexOf(line_separator) != -1) {
                    this.flush();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void print(char[] s) throws NullPointerException {
        this.print(new String(s));
    }

    public void print(boolean b) {
        this.print(String.valueOf(b));
    }

    public void print(char c) {
        this.print(String.valueOf(c));
    }

    public void print(int i) {
        this.print(String.valueOf(i));
    }

    public void print(long l) {
        this.print(String.valueOf(l));
    }

    public void print(float f) {
        this.print(String.valueOf(f));
    }

    public void print(double d) {
        this.print(String.valueOf(d));
    }

    public void println() {
        this.println("");
    }

    public void println(Object obj) {
        this.println(String.valueOf(obj));
    }

    public void println(String s) {
        if (s == null) {
            this.println("null");
        } else {
            try {
                byte[] b = s.getBytes();
                this.write(b);
                this.write(newline_bytes);
            }
            catch (Exception e) {
                System.err.println("Printstream.println(String) threw exception " + e);
            }
        }
    }

    public void println(char[] s) throws NullPointerException {
        this.println(new String(s));
    }

    public void println(boolean b) {
        this.println(String.valueOf(b));
    }

    public void println(char c) {
        this.println(String.valueOf(c));
    }

    public void println(int i) {
        this.println(String.valueOf(i));
    }

    public void println(long l) {
        this.println(String.valueOf(l));
    }

    public void println(float f) {
        this.println(String.valueOf(f));
    }

    public void println(double d) {
        this.println(String.valueOf(d));
    }
}

