/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.PipedReader;
import java.io.Writer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PipedWriter
extends Writer {
    private static final int pSize = 1024;
    private boolean closed;
    private Thread thread;
    private PipedReader sinkR;
    private char[] pipe;
    private int[] pointers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                this.pipe = null;
                this.pointers = null;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(PipedReader sink) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed && this.pipe == null) {
                int[] p = new int[2];
                sink.setPointers(p);
                this.pointers = p;
                this.pipe = new char[1024];
                sink.setPipe(this.pipe);
                this.sinkR = sink;
                this.thread = sink.switchThreads(this.thread, this);
                return;
            }
            throw new IOException();
        }
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(int ch) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed || !this.thread.isAlive() || this.pipe == null) {
                throw new IOException();
            }
            do {
                if (1023 - (1024 + this.pointers[1] - this.pointers[0]) % 1024 != 0) {
                    this.pipe[this.pointers[1]] = (char)ch;
                    this.pointers[1] = (this.pointers[1] + 1) % 1024;
                    return;
                }
                Thread.yield();
            } while (this.thread.isAlive() && !this.sinkR.closed());
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(char[] buff, int offset, int count) throws IOException {
        if (offset < 0 || count < 0 || offset + count > buff.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed || !this.thread.isAlive() || this.pipe == null) {
                throw new IOException();
            }
            while (count > 0) {
                int space = 1023 - (1024 + this.pointers[1] - this.pointers[0]) % 1024;
                while (space == 0) {
                    Thread.yield();
                    if (!this.thread.isAlive() || this.sinkR.closed()) {
                        throw new IOException();
                    }
                    space = 1023 - (1024 + this.pointers[1] - this.pointers[0]) % 1024;
                }
                space = space > count ? count : space;
                this.internalwrite(buff, offset, space);
                offset += space;
                count -= space;
            }
            return;
        }
    }

    private final void internalwrite(char[] buff, int offset, int count) {
        if (count + this.pointers[1] <= 1024) {
            System.arraycopy(buff, offset, this.pipe, this.pointers[1], count);
            this.pointers[1] = this.pointers[1] + count;
        } else {
            int nr = 1024 - this.pointers[1];
            System.arraycopy(buff, offset, this.pipe, this.pointers[1], nr);
            this.pointers[1] = 0;
            this.internalwrite(buff, offset + nr, count - nr);
        }
    }

    boolean closed() {
        return this.closed;
    }

    private final /* synthetic */ void this() {
        this.closed = false;
    }

    public PipedWriter() {
        this.this();
        this.thread = Thread.currentThread();
    }

    public PipedWriter(PipedReader sink) throws IOException {
        this.this();
        this.thread = Thread.currentThread();
        this.connect(sink);
    }
}

