/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.WeakHashMap;

public class ObjectStreamClass
implements Serializable {
    private static final long serialVersionUID = -6120832682080437368L;
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    static final int IS_ARRAY = 0x1000000;
    static final int IS_BAD = 0x800000;
    static final int IS_NOT_SER = 0x400000;
    static final int WRONG_SUID = 0x200000;
    private static WeakHashMap streamClassCache = new WeakHashMap();
    String name;
    ObjectStreamClass parent;
    long suid;
    Class clazz;
    int flags;
    Method writeObject;
    Method writeReplace;
    Method readObject;
    Method readResolve;
    ObjectStreamField[] osFields;

    private static native ObjectStreamClass createObjectStreamClass(Class var0);

    public static ObjectStreamClass lookup(Class cl) {
        ObjectStreamClass o;
        block2: {
            ObjectStreamClass parent;
            o = (ObjectStreamClass)streamClassCache.get(cl);
            if (o != null || (o = ObjectStreamClass.createObjectStreamClass(cl)) == null) break block2;
            o.name = cl.getName();
            streamClassCache.put(cl, o);
            ObjectStreamClass current = o;
            while ((parent = (ObjectStreamClass)streamClassCache.get(cl = cl.getSuperclass())) == null) {
                parent = ObjectStreamClass.createObjectStreamClass(cl);
                if (parent != null) {
                    current.parent = parent;
                    streamClassCache.put(cl, parent);
                    parent.name = cl.getName();
                    current = parent;
                    continue;
                }
                break block2;
            }
            current.parent = parent;
        }
        return o;
    }

    ObjectStreamClass(String name) {
        this.name = name;
    }

    ObjectStreamClass(String name, long suid, int flags) {
        this.name = name;
        this.suid = suid;
        this.flags = flags;
    }

    public Class forClass() {
        return this.clazz;
    }

    public ObjectStreamField getField(String name) {
        ObjectStreamField[] fields = this.osFields;
        if (fields == null) {
            this.osFields = fields = this.getFields();
        }
        int l = fields.length;
        for (int i = 0; i < l; ++i) {
            if (!name.equals(fields[i].name)) continue;
            return fields[i];
        }
        return null;
    }

    public ObjectStreamField[] getFields() {
        if (this.osFields == null) {
            Object[] flds = this.createFields();
            if (flds == null) {
                flds = NO_FIELDS;
            } else {
                Arrays.sort(flds);
            }
            this.osFields = flds;
        }
        return this.osFields;
    }

    public String getName() {
        return this.name;
    }

    public long getSerialVersionUID() {
        return this.suid;
    }

    public String toString() {
        return "ObjectStreamClass: '" + this.name + "' SUID = " + this.suid;
    }

    native void verifyInput() throws IOException;

    private native ObjectStreamField[] createFields();
}

