/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import wonka.decoders.UTF8Decoder;
import wonka.vm.ArrayUtil;

public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private static final int BUFFERSIZE = 1024;
    private static final Class clazzObjectStreamClass = new ObjectStreamClass("").getClass();
    private static final Class clazzClass = clazzObjectStreamClass.getClass();
    private static final Class clazzString = "".getClass();
    private static final Class[] EMPTY = new Class[0];
    static final Object[] NO_ARGS = new Object[0];
    private static final Class[] arrayClazz = new Class[]{class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = ObjectOutputStream.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream};
    private Object[] args;
    private OutputStream out;
    private final byte[] buffer;
    private int pointer;
    private byte[] databuffer;
    private int datapointer;
    private int handleCounter;
    private Object[] objectCache;
    private int[] handles;
    private int hthreshold;
    private int hcapacity;
    private int hoccupancy;
    private Object[] replacementCache;
    private Object[] replacements;
    private int rthreshold;
    private int rcapacity;
    private int roccupancy;
    private Object active;
    private ObjectStreamClass currentObjectStreamClass;
    private boolean enableReplaceObject;
    private boolean override;
    static /* synthetic */ Class class$java$io$ObjectOutputStream;

    protected ObjectOutputStream() throws IOException, SecurityException {
        this.args = new Object[1];
        this.args[0] = this;
        this.override = true;
        this.buffer = null;
    }

    public ObjectOutputStream(OutputStream out) throws IOException {
        this.out = out;
        this.buffer = new byte[1024];
        this.databuffer = new byte[1024];
        this.args = new Object[1];
        this.args[0] = this;
        this.handleCounter = 0x7E0000;
        this.objectCache = new Object[101];
        this.handles = new int[101];
        this.hthreshold = 75;
        this.hcapacity = 101;
        this.replacementCache = new Object[101];
        this.replacements = new Object[101];
        this.rthreshold = 75;
        this.rcapacity = 101;
        this.writeStreamHeader();
    }

    protected void annotateClass(Class clazz) throws IOException {
    }

    protected void annotateProxyClass(Class clazz) throws IOException {
    }

    public void close() throws IOException {
        this.drain();
        this.out.close();
    }

    public void defaultWriteObject() throws IOException {
        Object current = this.active;
        ObjectStreamClass osc = this.currentObjectStreamClass;
        if (current == null) {
            throw new NotActiveException("Not serializing an object");
        }
        ObjectStreamField[] osfields = osc.getFields();
        int len = osfields.length;
        byte[] buf = this.buffer;
        try {
            for (int i = 0; i < len; ++i) {
                ObjectStreamField osfield = osfields[i];
                Field f = osfield.field;
                if (f == null) {
                    InvalidClassException ice = new InvalidClassException("no field " + osfield.name + " of " + osfield.type + " in " + osc.name);
                    ice.classname = osc.name;
                    this.handleException(ice);
                }
                if (osfield.isPrimitive) {
                    if (this.datapointer > 0 || this.pointer + 8 > 1024) {
                        this.drain();
                    }
                    int p = this.pointer;
                    switch (osfield.code) {
                        case 'I': {
                            ArrayUtil.iInBArray(f.getInt(current), buf, p);
                            p += 4;
                            break;
                        }
                        case 'J': {
                            ArrayUtil.lInBArray(f.getLong(current), buf, p);
                            p += 8;
                            break;
                        }
                        case 'F': {
                            ArrayUtil.fInBArray(f.getFloat(current), buf, p);
                            p += 4;
                            break;
                        }
                        case 'D': {
                            ArrayUtil.dInBArray(f.getDouble(current), buf, p);
                            p += 8;
                            break;
                        }
                        case 'B': {
                            buf[p++] = f.getByte(current);
                            break;
                        }
                        case 'Z': {
                            buf[p++] = (byte)(f.getBoolean(current) ? 1 : 0);
                            break;
                        }
                        case 'C': {
                            char ch = f.getChar(current);
                            buf[p++] = (byte)(ch >> 8);
                            buf[p++] = (byte)ch;
                            break;
                        }
                        case 'S': {
                            short s = f.getShort(current);
                            buf[p++] = (byte)(s >> 8);
                            buf[p++] = (byte)s;
                            break;
                        }
                        default: {
                            throw new StreamCorruptedException("trying to write primitive field with code '" + osfield.code + "'");
                        }
                    }
                    this.pointer = p;
                    continue;
                }
                this.writeObject(f.get(current));
            }
        }
        catch (IllegalAccessException iae) {
            this.handleException(iae);
        }
    }

    protected void drain() throws IOException {
        int p = this.pointer;
        byte[] buf = this.buffer;
        if (this.datapointer > 0) {
            int dp = this.datapointer;
            if (p > 1019) {
                this.out.write(buf, 0, p);
                p = 0;
            }
            if (dp < 256) {
                buf[p++] = 119;
                buf[p++] = (byte)dp;
            } else {
                buf[p++] = 122;
                ArrayUtil.iInBArray(dp, buf, p);
                p += 4;
            }
            this.out.write(buf, 0, p);
            this.pointer = 0;
            this.out.write(this.databuffer, 0, dp);
            this.datapointer = 0;
        } else {
            this.out.write(buf, 0, p);
            this.pointer = 0;
        }
    }

    protected boolean enableReplaceObject(boolean enable) throws SecurityException {
        boolean b = this.enableReplaceObject;
        this.enableReplaceObject = enable;
        return b;
    }

    public void flush() throws IOException {
        this.drain();
        this.out.flush();
    }

    public PutField putFields() throws IOException {
        return null;
    }

    protected Object replaceObject(Object obj) throws IOException {
        return obj;
    }

    public void reset() throws IOException {
        if (this.active != null) {
            throw new IOException("cannot reset while serializing an object");
        }
        if (this.datapointer > 0 || this.pointer >= 1024) {
            this.drain();
        }
        this.buffer[this.pointer++] = 121;
        this.objectCache = new Object[101];
        this.handles = new int[101];
        this.hthreshold = 75;
        this.hcapacity = 101;
        this.hoccupancy = 0;
        this.replacementCache = new Object[101];
        this.replacements = new Object[101];
        this.rthreshold = 75;
        this.rcapacity = 101;
        this.roccupancy = 0;
        this.handleCounter = 0x7E0000;
    }

    public void useProtocolVersion(int version) throws IOException {
        if (version != 1 && version != 1) {
            throw new IllegalArgumentException("protocol version " + version + " not supported");
        }
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        if (this.datapointer + len > this.databuffer.length) {
            this.grow(len);
        }
        System.arraycopy(buf, off, this.databuffer, this.datapointer, len);
        this.datapointer += len;
    }

    public void write(int data) throws IOException {
        if (this.datapointer >= this.databuffer.length) {
            this.grow(1024);
        }
        this.databuffer[this.datapointer++] = (byte)data;
    }

    public void writeBoolean(boolean data) throws IOException {
        if (this.datapointer >= this.databuffer.length) {
            this.grow(1024);
        }
        this.databuffer[this.datapointer++] = (byte)(data ? 1 : 0);
    }

    public void writeByte(int data) throws IOException {
        if (this.datapointer >= this.databuffer.length) {
            this.grow(1024);
        }
        this.databuffer[this.datapointer++] = (byte)data;
    }

    public void writeBytes(String string) throws IOException {
        byte[] buf = string.getBytes("latin1");
        int len = buf.length;
        if (this.datapointer > this.databuffer.length - len) {
            this.grow(len);
        }
        System.arraycopy(buf, 0, this.databuffer, this.datapointer, len);
        this.datapointer += len;
    }

    public void writeChar(int data) throws IOException {
        if (this.datapointer + 2 > this.databuffer.length) {
            this.grow(1024);
        }
        this.databuffer[this.datapointer++] = (byte)(data >> 8);
        this.databuffer[this.datapointer++] = (byte)data;
    }

    public void writeChars(String string) throws IOException {
        byte[] buf = string.getBytes("UTF-16BE");
        int len = buf.length;
        if (this.datapointer > this.databuffer.length - len) {
            this.grow(len);
        }
        System.arraycopy(buf, 0, this.databuffer, this.datapointer, len);
        this.datapointer += len;
    }

    protected void writeClassDescriptor(ObjectStreamClass osc) throws IOException {
        int p;
        byte[] bytes = UTF8Decoder.stringToB(osc.name);
        int len = bytes.length;
        byte[] buf = this.buffer;
        if (this.pointer + len >= 1011) {
            this.drain();
            if (len > 1011) {
                buf[0] = (byte)(len >> 8);
                buf[1] = (byte)len;
                this.out.write(buf, 0, 2);
                this.out.write(bytes, 0, len);
                p = 0;
            } else {
                p = this.pointer;
                buf[p++] = (byte)(len >> 8);
                buf[p++] = (byte)len;
                System.arraycopy(bytes, 0, buf, p, len);
                p += len;
            }
        } else {
            p = this.pointer;
            buf[p++] = (byte)(len >> 8);
            buf[p++] = (byte)len;
            System.arraycopy(bytes, 0, buf, p, len);
            p += len;
        }
        ArrayUtil.lInBArray(osc.suid, buf, p);
        p += 8;
        buf[p++] = (byte)osc.flags;
        ObjectStreamField[] fields = osc.getFields();
        len = fields.length;
        buf[p++] = (byte)(len >> 8);
        buf[p++] = (byte)len;
        for (int i = 0; i < len; ++i) {
            ObjectStreamField osf = fields[i];
            bytes = UTF8Decoder.stringToB(osf.name);
            int l = bytes.length;
            if (p + l > 1021) {
                this.out.write(buf, 0, p);
                p = 0;
                if (l > 1021) {
                    buf[0] = (byte)osf.code;
                    buf[1] = (byte)(l >> 8);
                    buf[2] = (byte)l;
                    this.out.write(buf, 0, 3);
                    this.out.write(bytes, 0, l);
                } else {
                    buf[p++] = (byte)osf.code;
                    buf[p++] = (byte)(l >> 8);
                    buf[p++] = (byte)l;
                    System.arraycopy(bytes, 0, buf, p, l);
                    p += l;
                }
            } else {
                buf[p++] = (byte)osf.code;
                buf[p++] = (byte)(l >> 8);
                buf[p++] = (byte)l;
                System.arraycopy(bytes, 0, buf, p, l);
                p += l;
            }
            if (osf.isPrimitive) continue;
            this.pointer = p;
            this.writeObject(osf.typeString);
            p = this.pointer;
        }
        this.pointer = p;
        this.annotateClass(osc.clazz);
        p = this.pointer;
        if (p >= 1024) {
            this.out.write(buf, 0, p);
            p = 0;
        }
        buf[p++] = 120;
        ObjectStreamClass tmp = osc.parent;
        if (tmp == null) {
            if (p >= 1024) {
                this.out.write(buf, 0, p);
                p = 0;
            }
            buf[p++] = 112;
            this.pointer = p;
        } else {
            this.pointer = p;
            this.writeObject(tmp);
        }
    }

    public void writeDouble(double d) throws IOException {
        int dp = this.datapointer;
        if (dp + 8 > this.databuffer.length) {
            this.grow(1024);
        }
        ArrayUtil.dInBArray(d, this.databuffer, dp);
        this.datapointer = dp + 8;
    }

    public void writeFields() throws IOException {
    }

    public void writeFloat(float f) throws IOException {
        int dp = this.datapointer;
        if (dp + 4 > this.databuffer.length) {
            this.grow(1024);
        }
        ArrayUtil.fInBArray(f, this.databuffer, dp);
        this.datapointer = dp + 4;
    }

    public void writeInt(int data) throws IOException {
        int dp = this.datapointer;
        if (dp + 4 > this.databuffer.length) {
            this.grow(1024);
        }
        ArrayUtil.iInBArray(data, this.databuffer, dp);
        this.datapointer = dp + 4;
    }

    public void writeLong(long data) throws IOException {
        int dp = this.datapointer;
        if (dp + 8 > this.databuffer.length) {
            this.grow(1024);
        }
        ArrayUtil.lInBArray(data, this.databuffer, dp);
        this.datapointer = dp + 8;
    }

    public final void writeObject(Object obj) throws IOException {
        Class objClass;
        if (this.override) {
            this.writeObjectOverride(obj);
            return;
        }
        if (this.datapointer > 0 || this.pointer > 1015) {
            this.drain();
        }
        byte[] buf = this.buffer;
        while (true) {
            int handle;
            if (obj == null) {
                buf[this.pointer++] = 112;
                if (this.active == null) {
                    this.drain();
                }
                return;
            }
            int cap = this.rcapacity;
            int ihash = System.identityHashCode(obj);
            int hash = ihash % cap;
            Object[] k = this.replacementCache;
            while (true) {
                Object k2;
                if (hash < 0) {
                    hash += cap;
                }
                if ((k2 = k[hash]) == null) break;
                if (obj == k2) {
                    obj = this.replacements[hash];
                    if (obj == null) {
                        buf[this.pointer++] = 112;
                        if (this.active == null) {
                            this.drain();
                        }
                        return;
                    }
                    ihash = System.identityHashCode(obj);
                    break;
                }
                --hash;
            }
            if ((handle = this.getHandle(obj, ihash)) != -1) {
                int p = this.pointer;
                buf[p++] = 113;
                ArrayUtil.iInBArray(handle, buf, p);
                this.pointer = p + 4;
                if (this.active == null) {
                    this.drain();
                }
                return;
            }
            objClass = obj.getClass();
            if (objClass == clazzClass) {
                buf[this.pointer++] = 118;
                Class clazz = (Class)obj;
                ObjectStreamClass osc = ObjectStreamClass.lookup(clazz);
                if (osc == null) {
                    this.put(obj, this.handleCounter++);
                    byte[] bytes = UTF8Decoder.stringToB(clazz.getName());
                    int l = bytes.length;
                    int p = this.pointer;
                    buf[p++] = 114;
                    buf[p++] = (byte)(l >> 8);
                    buf[p++] = (byte)l;
                    if (l + p > 1011) {
                        this.out.write(buf, 0, p);
                        p = 0;
                        if (l > 1011) {
                            this.out.write(bytes, 0, l);
                        } else {
                            System.arraycopy(bytes, 0, buf, p, l);
                            p += l;
                        }
                    } else {
                        System.arraycopy(bytes, 0, buf, p, l);
                        p += l;
                    }
                    ArrayUtil.lInBArray(0L, buf, p);
                    p += 8;
                    buf[p++] = 120;
                    buf[p++] = 112;
                    this.pointer = p;
                } else {
                    this.writeObject(osc);
                }
                this.put(obj, this.handleCounter++);
                if (this.active == null) {
                    this.drain();
                }
                return;
            }
            if (clazzObjectStreamClass.isInstance(obj)) {
                this.put(obj, this.handleCounter++);
                ObjectStreamClass osc = (ObjectStreamClass)obj;
                buf[this.pointer++] = 114;
                this.writeClassDescriptor(osc);
                if (this.active == null) {
                    this.drain();
                }
                return;
            }
            boolean same = true;
            Object replace = obj;
            try {
                Method writeReplace = objClass.getDeclaredMethod("writeReplace", EMPTY);
                replace = writeReplace.invoke(obj, NO_ARGS);
                same = replace == obj;
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (InvocationTargetException ite) {
                this.handleException(ite.getTargetException());
            }
            catch (IllegalAccessException iae) {
                this.handleException(iae);
            }
            if (this.enableReplaceObject) {
                boolean bl = same = (replace = this.replaceObject(replace)) == obj;
            }
            if (same) break;
            this.putReplacement(obj, replace);
            obj = replace;
        }
        if (objClass == clazzString) {
            String s = (String)obj;
            byte[] bytes = UTF8Decoder.stringToB(s);
            int len = bytes.length;
            int p = this.pointer;
            if (len < 65536) {
                buf[p++] = 116;
                buf[p++] = (byte)(len >> 8);
                buf[p++] = (byte)len;
            } else {
                buf[p++] = 124;
                ArrayUtil.lInBArray((long)len & 0xFFFFFFFFL, buf, p);
                p += 8;
            }
            if (len > 1024 - p) {
                this.out.write(buf, 0, p);
                this.out.write(bytes, 0, len);
                this.pointer = 0;
            } else {
                System.arraycopy(bytes, 0, buf, p, len);
                this.pointer = p + len;
            }
            this.put(obj, this.handleCounter++);
            if (this.active == null) {
                this.drain();
            }
            return;
        }
        ObjectStreamClass osc = ObjectStreamClass.lookup(objClass);
        if (osc == null) {
            throw new NotSerializableException(obj + " of " + objClass + " is not Serializable");
        }
        Object current = this.active;
        this.active = obj;
        if ((osc.flags & 0x1000000) > 0) {
            buf[this.pointer++] = 117;
            this.writeObject(osc);
            this.put(obj, this.handleCounter++);
            Class ctype = objClass.getComponentType();
            if (ctype.isPrimitive()) {
                int p = this.pointer;
                byte[] bytes = this.primitiveArrayToBytes(obj);
                ArrayUtil.iInBArray(this.pointer, buf, p);
                int l = bytes.length;
                if ((p += 4) + l > 1024) {
                    this.out.write(buf, 0, p);
                    this.out.write(bytes, 0, l);
                    this.pointer = 0;
                } else {
                    System.arraycopy(bytes, 0, buf, p, l);
                    this.pointer = p + l;
                }
            } else {
                Object[] objectArray = (Object[])obj;
                int p = this.pointer;
                int arrayLength = objectArray.length;
                ArrayUtil.iInBArray(arrayLength, buf, p);
                this.pointer = p + 4;
                for (int i = 0; i < arrayLength; ++i) {
                    this.writeObject(objectArray[i]);
                }
            }
            if (current == null) {
                this.drain();
            }
            this.active = current;
            return;
        }
        buf[this.pointer++] = 115;
        this.writeObject(osc);
        this.put(obj, this.handleCounter++);
        ObjectStreamClass curOsc = this.currentObjectStreamClass;
        if ((osc.flags & 4) > 0) {
            this.currentObjectStreamClass = osc;
            ((Externalizable)obj).writeExternal(this);
            if (this.datapointer > 0 || this.pointer >= 1024) {
                this.drain();
            }
            buf[this.pointer++] = 120;
        } else {
            int size = 128;
            ObjectStreamClass[] array = new ObjectStreamClass[size];
            int i = 0;
            do {
                if (i == size) {
                    ObjectStreamClass[] newArray = new ObjectStreamClass[size *= 2];
                    System.arraycopy(array, 0, newArray, 0, i);
                    array = newArray;
                }
                array[i++] = osc;
            } while ((osc = osc.parent) != null);
            do {
                this.currentObjectStreamClass = osc = array[--i];
                Method writeObject = osc.writeObject;
                if (writeObject == null) {
                    this.defaultWriteObject();
                    continue;
                }
                try {
                    writeObject.invoke(obj, this.args);
                    if (this.datapointer > 0 || this.pointer >= 1024) {
                        this.drain();
                    }
                    buf[this.pointer++] = 120;
                }
                catch (InvocationTargetException ite) {
                    this.handleException(ite.getTargetException());
                }
                catch (IllegalAccessException iae) {
                    this.handleException(iae);
                }
            } while (i > 0);
        }
        this.active = current;
        if (current == null) {
            this.drain();
        }
        this.currentObjectStreamClass = curOsc;
    }

    protected void writeObjectOverride(Object obj) throws IOException {
    }

    public void writeShort(int data) throws IOException {
        if (this.datapointer + 2 > this.databuffer.length) {
            this.grow(1024);
        }
        this.databuffer[this.datapointer++] = (byte)(data >> 8);
        this.databuffer[this.datapointer++] = (byte)data;
    }

    protected void writeStreamHeader() throws IOException {
        byte[] buf = this.buffer;
        buf[0] = -84;
        buf[1] = -19;
        buf[2] = 0;
        buf[3] = 5;
        this.out.write(buf, 0, 4);
    }

    public void writeUTF(String s) throws IOException {
        byte[] bytes = UTF8Decoder.stringToB(s);
        int len = bytes.length;
        if (len > 65535) {
            throw new UTFDataFormatException("to much bytes in string");
        }
        if (this.datapointer + 2 + len > this.databuffer.length) {
            this.grow(len + 2);
        }
        this.databuffer[this.datapointer++] = (byte)(len >> 8);
        this.databuffer[this.datapointer++] = (byte)len;
        System.arraycopy(bytes, 0, this.databuffer, this.datapointer, len);
        this.datapointer += len;
    }

    private void grow(int size) {
        byte[] buf = this.databuffer;
        if (size < 1024) {
            size = 1024;
        }
        this.databuffer = new byte[size + buf.length];
        System.arraycopy(buf, 0, this.databuffer, 0, this.datapointer);
    }

    private void handleException(Throwable e) throws IOException {
        if (e instanceof IOException) {
            if (this.datapointer > 0 || this.pointer >= 1024) {
                this.drain();
            }
            this.buffer[this.pointer++] = 123;
            this.objectCache = new Object[101];
            this.handles = new int[101];
            this.hthreshold = 75;
            this.hcapacity = 101;
            this.hoccupancy = 0;
            this.replacementCache = new Object[101];
            this.replacements = new Object[101];
            this.rthreshold = 75;
            this.rcapacity = 101;
            this.roccupancy = 0;
            this.handleCounter = 0x7E0000;
            this.writeObject(e);
            this.drain();
            throw (IOException)e;
        }
        throw new StreamCorruptedException("stream got corrupted by " + e);
    }

    private native byte[] primitiveArrayToBytes(Object var1);

    private int getHandle(Object key, int hash) {
        int cap = this.hcapacity;
        Object[] k = this.objectCache;
        hash %= cap;
        while (true) {
            Object k2;
            if (hash < 0) {
                hash += cap;
            }
            if ((k2 = k[hash]) == null) {
                return -1;
            }
            if (key == k2) {
                return this.handles[hash];
            }
            --hash;
        }
    }

    private void put(Object key, int handle) {
        int cap = this.hcapacity;
        int hash = System.identityHashCode(key) % cap;
        Object[] k = this.objectCache;
        while (true) {
            Object k2;
            if (hash < 0) {
                hash += cap;
            }
            if ((k2 = k[hash]) == null) {
                k[hash] = key;
                this.handles[hash] = handle;
                if (++this.hoccupancy >= this.hthreshold) {
                    this.hRehash();
                }
                return;
            }
            --hash;
        }
    }

    private void hRehash() {
        int oldsize = this.hcapacity;
        int newsize = oldsize * 2 + 1;
        Object[] oldkeys = this.objectCache;
        int[] oldvalues = this.handles;
        this.objectCache = new Object[newsize];
        this.handles = new int[newsize];
        this.hcapacity = newsize;
        this.hthreshold = (int)((float)newsize * 0.75f);
        this.hoccupancy = 0;
        for (int oldindex = 0; oldindex < oldsize; ++oldindex) {
            Object key = oldkeys[oldindex];
            if (key == null) continue;
            this.put(key, oldvalues[oldindex]);
        }
    }

    private void putReplacement(Object key, Object handle) {
        int cap = this.rcapacity;
        int hash = System.identityHashCode(key) % cap;
        Object[] k = this.replacementCache;
        while (true) {
            Object k2;
            if (hash < 0) {
                hash += cap;
            }
            if ((k2 = k[hash]) == null) {
                k[hash] = key;
                this.replacements[hash] = handle;
                ++this.roccupancy;
                if (this.roccupancy >= this.rthreshold) {
                    this.rRehash();
                }
                return;
            }
            --hash;
        }
    }

    private void rRehash() {
        int oldsize = this.rcapacity;
        int newsize = oldsize * 2 + 1;
        Object[] oldkeys = this.replacementCache;
        Object[] oldvalues = this.replacements;
        this.replacementCache = new Object[newsize];
        this.replacements = new Object[newsize];
        this.rcapacity = newsize;
        this.rthreshold = (int)((float)newsize * 0.75f);
        this.roccupancy = 0;
        for (int oldindex = 0; oldindex < oldsize; ++oldindex) {
            Object key = oldkeys[oldindex];
            if (key == null) continue;
            this.putReplacement(key, oldvalues[oldindex]);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static abstract class PutField {
        public abstract void put(String var1, boolean var2);

        public abstract void put(String var1, byte var2);

        public abstract void put(String var1, char var2);

        public abstract void put(String var1, double var2);

        public abstract void put(String var1, float var2);

        public abstract void put(String var1, int var2);

        public abstract void put(String var1, long var2);

        public abstract void put(String var1, Object var2);

        public abstract void put(String var1, short var2);

        public abstract void write(ObjectOutput var1);
    }
}

