/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LineNumberInputStream
extends FilterInputStream {
    static final int NEWLINE = 10;
    static final int RETURN = 13;
    private int linecount;
    private int marked_linecount;
    private boolean skipNewLine;

    public int read() throws IOException {
        int nextbyte = this.in.read();
        if (nextbyte < 0) {
            return nextbyte;
        }
        if (nextbyte == 10) {
            if (this.skipNewLine) {
                this.skipNewLine = false;
                return this.read();
            }
            ++this.linecount;
        } else {
            if (nextbyte == 13) {
                this.skipNewLine = true;
                ++this.linecount;
                return 10;
            }
            this.skipNewLine = false;
        }
        return nextbyte;
    }

    public int read(byte[] b, int off, int len) throws IOException, NullPointerException, ArrayIndexOutOfBoundsException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int i = 0;
        while (i < len) {
            int nextbyte = this.read();
            if (nextbyte < 0) break;
            b[i + off] = (byte)nextbyte;
            ++i;
        }
        if (i == 0) {
            return -1;
        }
        return i;
    }

    public long skip(long n) throws IOException {
        long j = 0L;
        while (j < n) {
            int nextbyte = this.read();
            if (nextbyte < 0) break;
            ++j;
        }
        return j;
    }

    public int available() throws IOException {
        return this.in.available() / 2;
    }

    public void mark(int readLimit) {
        this.marked_linecount = this.linecount;
        this.in.mark(readLimit);
    }

    public void reset() throws IOException {
        this.in.reset();
        this.linecount = this.marked_linecount;
    }

    public int getLineNumber() {
        return this.linecount;
    }

    public void setLineNumber(int lineNumber) {
        this.linecount = lineNumber;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    private final /* synthetic */ void this() {
        this.linecount = 0;
        this.marked_linecount = 0;
    }

    public LineNumberInputStream(InputStream in) {
        super(in);
        this.this();
    }
}

