/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MemoryImageSource
implements ImageProducer {
    private Vector consumers;
    private Hashtable properties;
    private int width;
    private int height;
    private int offset;
    private int scansize;
    private int[] pixels_int;
    private byte[] pixels_byte;
    private ColorModel colorModel;
    private boolean animated;

    public void newPixels() {
        if (this.animated) {
            this.startProduction(null);
        }
    }

    public synchronized void newPixels(byte[] pixels, ColorModel cm, int offset, int scansize) {
        if (this.animated) {
            this.pixels_int = null;
            this.pixels_byte = pixels;
            this.colorModel = cm;
            this.offset = offset;
            this.scansize = scansize;
            this.newPixels();
        }
    }

    public synchronized void newPixels(int[] pixels, ColorModel cm, int offset, int scansize) {
        if (this.animated) {
            this.pixels_int = pixels;
            this.pixels_byte = null;
            this.colorModel = cm;
            this.offset = offset;
            this.scansize = scansize;
            this.newPixels();
        }
    }

    public synchronized void newPixels(int x, int y, int width, int height) {
        if (this.animated) {
            this.newPixels(x, y, width, height, true);
        }
    }

    public synchronized void newPixels(int x, int y, int width, int height, boolean frameNotify) {
        if (this.animated) {
            Iterator iter = this.consumers.iterator();
            while (iter.hasNext()) {
                int j;
                int i;
                Object[] newpixels;
                ImageConsumer consumer = (ImageConsumer)iter.next();
                consumer.setDimensions(width, height);
                consumer.setProperties(this.properties);
                consumer.setColorModel(this.colorModel);
                if (this.pixels_int != null) {
                    newpixels = new int[width];
                    i = 0;
                    while (i < height) {
                        j = 0;
                        while (j < width) {
                            newpixels[j] = this.pixels_int[(i + y) * this.width + j + x];
                            ++j;
                        }
                        consumer.setPixels(0, i, width, 1, this.colorModel, (int[])newpixels, 0, width);
                        ++i;
                    }
                } else if (this.pixels_byte != null) {
                    newpixels = new byte[width];
                    i = 0;
                    while (i < height) {
                        j = 0;
                        while (j < width) {
                            newpixels[j] = this.pixels_byte[(i + y) * this.width + j + x];
                            ++j;
                        }
                        consumer.setPixels(0, i, width, 1, this.colorModel, (byte[])newpixels, 0, width);
                        ++i;
                    }
                }
                consumer.imageComplete(2);
            }
        }
    }

    public synchronized void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public synchronized void setFullBufferUpdates(boolean full) {
        System.out.println("[MemoryImageSource] setFullBufferUpdates not yet supported...");
    }

    public void addConsumer(ImageConsumer ic) {
        if (!this.consumers.contains(ic)) {
            this.consumers.add(ic);
        }
    }

    public boolean isConsumer(ImageConsumer ic) {
        return this.consumers.contains(ic);
    }

    public void removeConsumer(ImageConsumer ic) {
        this.consumers.remove(ic);
    }

    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    public synchronized void startProduction(ImageConsumer consumer) {
        if (consumer != null) {
            this.addConsumer(consumer);
        }
        Iterator iter = this.consumers.iterator();
        while (iter.hasNext()) {
            Object[] newpixels;
            consumer = (ImageConsumer)iter.next();
            consumer.setDimensions(this.width, this.height);
            consumer.setProperties(this.properties);
            consumer.setColorModel(this.colorModel);
            if (this.pixels_int != null) {
                newpixels = (int[])this.pixels_int.clone();
                consumer.setPixels(0, 0, this.width, this.height, this.colorModel, (int[])newpixels, this.offset, this.scansize);
            } else if (this.pixels_byte != null) {
                newpixels = (byte[])this.pixels_byte.clone();
                consumer.setPixels(0, 0, this.width, this.height, this.colorModel, (byte[])newpixels, this.offset, this.scansize);
            }
            if (this.animated) {
                consumer.imageComplete(2);
                continue;
            }
            consumer.imageComplete(8);
        }
    }

    private final /* synthetic */ void this() {
        this.consumers = new Vector();
        this.pixels_int = null;
        this.pixels_byte = null;
        this.animated = false;
    }

    public MemoryImageSource(int width, int height, int[] pixels, int offset, int scansize) {
        this(width, height, pixels, offset, scansize, null);
    }

    public MemoryImageSource(int width, int height, int[] pixels, int offset, int scansize, Hashtable props) {
        this.this();
        this.width = width;
        this.height = height;
        this.offset = offset;
        this.scansize = scansize;
        this.properties = props;
        this.pixels_int = pixels;
        this.colorModel = ColorModel.getRGBdefault();
    }

    public MemoryImageSource(int width, int height, ColorModel cm, byte[] pixels, int offset, int scansize) {
        this(width, height, cm, pixels, offset, scansize, (Hashtable)null);
    }

    public MemoryImageSource(int width, int height, ColorModel cm, int[] pixels, int offset, int scansize) {
        this(width, height, cm, pixels, offset, scansize, null);
    }

    public MemoryImageSource(int width, int height, ColorModel cm, byte[] pixels, int offset, int scansize, Hashtable props) {
        this.this();
        this.width = width;
        this.height = height;
        this.offset = offset;
        this.scansize = scansize;
        this.properties = props;
        this.pixels_byte = pixels;
        this.colorModel = cm;
    }

    public MemoryImageSource(int width, int height, ColorModel cm, int[] pixels, int offset, int scansize, Hashtable props) {
        this.this();
        this.width = width;
        this.height = height;
        this.offset = offset;
        this.scansize = scansize;
        this.properties = props;
        this.pixels_int = pixels;
        this.colorModel = cm;
    }
}

