/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.util.Arrays;

public class IndexColorModel
extends ColorModel {
    private byte[] reds;
    private byte[] greens;
    private byte[] blues;
    private byte[] alphas;
    private int[] internal;
    private int size;
    private int bits;
    private int trans;

    public IndexColorModel(int nbits, int size, byte[] reds, byte[] greens, byte[] blues) {
        this(nbits, size, reds, greens, blues, -1);
    }

    public IndexColorModel(int nbits, int size, byte[] reds, byte[] greens, byte[] blues, int trans) {
        super(nbits);
        byte[] alphas = new byte[size];
        Arrays.fill(alphas, (byte)-1);
        this.setupArrays(size, reds, greens, blues, alphas);
        this.trans = trans;
        this.size = size;
        this.setup_internal();
    }

    public IndexColorModel(int nbits, int size, byte[] reds, byte[] greens, byte[] blues, byte[] alphas) {
        super(nbits);
        this.setupArrays(size, reds, greens, blues, alphas);
        this.trans = -1;
        this.size = size;
        this.setup_internal();
    }

    public IndexColorModel(int nbits, int size, byte[] cmap, int start, boolean hasAlpha) {
        this(nbits, size, cmap, start, hasAlpha, -1);
    }

    public IndexColorModel(int nbits, int size, byte[] cmap, int start, boolean hasAlpha, int trans) {
        super(nbits);
        this.trans = -1;
        this.size = size;
        this.reds = new byte[size];
        this.greens = new byte[size];
        this.blues = new byte[size];
        this.alphas = new byte[size];
        int j = start;
        if (hasAlpha) {
            for (int i = 0; i < size; ++i) {
                this.reds[i] = cmap[j++];
                this.greens[i] = cmap[j++];
                this.blues[i] = cmap[j++];
                this.alphas[i] = cmap[j++];
            }
        } else {
            for (int i = 0; i < size; ++i) {
                this.reds[i] = cmap[j++];
                this.greens[i] = cmap[j++];
                this.blues[i] = cmap[j++];
            }
            Arrays.fill(this.alphas, (byte)-1);
        }
        this.setup_internal();
    }

    private void setupArrays(int size, byte[] reds, byte[] greens, byte[] blues, byte[] alphas) {
        this.reds = new byte[size];
        this.greens = new byte[size];
        this.blues = new byte[size];
        this.alphas = new byte[size];
        System.arraycopy(reds, 0, this.reds, 0, size);
        System.arraycopy(greens, 0, this.greens, 0, size);
        System.arraycopy(blues, 0, this.blues, 0, size);
        System.arraycopy(alphas, 0, this.alphas, 0, size);
    }

    public final int getAlpha(int pixelValue) {
        return this.alphas[pixelValue];
    }

    public final void getAlphas(byte[] a) {
        for (int i = 0; i < this.size; ++i) {
            a[i] = this.alphas[i];
        }
    }

    public final int getRed(int pixelValue) {
        return this.reds[pixelValue &= (1 << this.pixel_bits) - 1] & 0xFF;
    }

    public final void getReds(byte[] r) {
        for (int i = 0; i < this.size; ++i) {
            r[i] = this.reds[i];
        }
    }

    public final int getGreen(int pixelValue) {
        return this.greens[pixelValue &= (1 << this.pixel_bits) - 1] & 0xFF;
    }

    public final void getGreens(byte[] g) {
        for (int i = 0; i < this.size; ++i) {
            g[i] = this.greens[i];
        }
    }

    public final int getBlue(int pixelValue) {
        return this.blues[pixelValue &= (1 << this.pixel_bits) - 1] & 0xFF;
    }

    public final void getBlues(byte[] b) {
        for (int i = 0; i < this.size; ++i) {
            b[i] = this.blues[i];
        }
    }

    public final int getMapSize() {
        return this.size;
    }

    public final int getTransparentPixel() {
        return this.trans;
    }

    public final int getRGB(int pixelValue) {
        return super.getRGB(pixelValue);
    }

    private native void fill_internal();

    private void setup_internal() {
        if (this.internal == null) {
            this.internal = new int[this.size];
        }
        this.fill_internal();
    }
}

