/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.AWTEvent;

public class ActionEvent
extends AWTEvent {
    public static final int ACTION_FIRST = 1001;
    public static final int ACTION_LAST = 1001;
    public static final int ACTION_PERFORMED = 1001;
    public static final int SHIFT_MASK = 1;
    public static final int CTRL_MASK = 2;
    public static final int ALT_MASK = 4;
    public static final int META_MASK = 8;
    String command;
    int modifiers;

    public ActionEvent(Object source, int id, String command) {
        this(source, id, command, 0);
    }

    public ActionEvent(Object source, int id, String command, int modifiers) {
        super(source, id);
        this.command = command;
        this.modifiers = modifiers;
    }

    public String getActionCommand() {
        return this.command;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String toString() {
        String display = this.getClass().getName() + "[ACTION_PERFORMED, ActionCommand = " + this.command + ", Modifiers=[";
        display = this.modifiers == 0 ? display + "None" : display + " ";
        if ((this.modifiers & 1) > 0) {
            display = display + "[SHIFT] ";
        }
        if ((this.modifiers & 2) > 0) {
            display = display + "[CTRL] ";
        }
        if ((this.modifiers & 4) > 0) {
            display = display + "[ALT] ";
        }
        if ((this.modifiers & 8) > 0) {
            display = display + "[META] ";
        }
        if ((this.modifiers & 0xF) != this.modifiers) {
            display = display + "[other] ";
        }
        display = display + "] on ";
        display = display + this.source.getClass().getName();
        return display;
    }

    public String paramString() {
        return this.getClass().getName() + "[source=" + this.source + ", command=" + this.command + ", modifiers=" + this.modifiers + "]";
    }
}

