/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.util.TooManyListenersException;

public class DragSourceContext
implements DragSourceListener {
    protected static final int DEFAULT = 0;
    protected static final int ENTER = 0;
    protected static final int OVER = 0;
    protected static final int CHANGED = 0;
    private DragGestureEvent trigger;
    private DragSourceContextPeer dscp;
    private Image image;
    private Point offset;
    private Transferable transferable;
    private DragSourceListener dragSourceListener;

    public DragSourceContext(DragSourceContextPeer dscp, DragGestureEvent trigger, Cursor dragCursor, Image dragImage, Point offset, Transferable t, DragSourceListener dsl) {
        this.trigger = trigger;
        this.dscp = dscp;
        this.dscp.setCursor(dragCursor);
        this.image = dragImage;
        this.offset = offset;
        this.transferable = t;
        this.dragSourceListener = dsl;
    }

    public DragSource getDragSource() {
        return this.trigger.getDragSource();
    }

    public Component getComponent() {
        return this.trigger.getComponent();
    }

    public DragGestureEvent getTrigger() {
        return this.trigger;
    }

    public int getSourceActions() {
        return this.trigger.getDragAction();
    }

    public void setCursor(Cursor c) {
        this.dscp.setCursor(c);
    }

    public Cursor getCursor() {
        return this.dscp.getCursor();
    }

    public void addDragSourceListener(DragSourceListener dsl) throws TooManyListenersException {
        if (this.dragSourceListener == null) {
            throw new TooManyListenersException();
        }
        this.dragSourceListener = dsl;
    }

    public void removeDragSourceListener(DragSourceListener dsl) {
        if (this.dragSourceListener.equals(dsl)) {
            this.dragSourceListener = null;
        }
    }

    public void transferablesFlavorsChanged() {
        this.dscp.transferablesFlavorsChanged();
    }

    public void dragEnter(DragSourceDragEvent dsde) {
        if (this.dragSourceListener != null) {
            this.dragSourceListener.dragEnter(dsde);
        }
    }

    public void dragOver(DragSourceDragEvent dsde) {
        if (this.dragSourceListener != null) {
            this.dragSourceListener.dragOver(dsde);
        }
    }

    public void dragExit(DragSourceEvent dse) {
        if (this.dragSourceListener != null) {
            this.dragSourceListener.dragExit(dse);
        }
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
        if (this.dragSourceListener != null) {
            this.dragSourceListener.dropActionChanged(dsde);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (this.dragSourceListener != null) {
            this.dragSourceListener.dragDropEnd(dsde);
        }
    }

    public Transferable getTransferable() {
        return this.transferable;
    }

    protected void updateCurrentCursor(int dropOp, int targetAct, int status) {
    }
}

