/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;

public class StringSelection
implements Transferable,
ClipboardOwner {
    private String data;

    public StringSelection(String data) {
        this.data = data;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavor = new DataFlavor[]{DataFlavor.stringFlavor, DataFlavor.plainTextFlavor};
        return dataFlavor;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) throws NullPointerException {
        if (flavor == null) {
            throw new NullPointerException("flavor is null");
        }
        return flavor.equals(DataFlavor.stringFlavor) || flavor.equals(DataFlavor.plainTextFlavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.data;
        }
        if (flavor.equals(DataFlavor.plainTextFlavor)) {
            return new StringReader(this.data);
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

