/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.peer.MenuPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class Menu
extends MenuItem
implements MenuContainer {
    private Vector items;
    private boolean tearOff = false;
    private boolean isHelpMenu;
    private int menuSerializedDataVersion;

    public Menu() {
        this(null);
    }

    public Menu(String label) {
        this(label, false);
    }

    public Menu(String label, boolean tearOff) {
        super(label);
        this.setName(label);
        this.tearOff = tearOff;
        this.items = new Vector();
    }

    public synchronized MenuItem add(MenuItem item) {
        item.parent = this;
        this.items.add(item);
        ((MenuPeer)this.peer).addItem(item);
        return item;
    }

    public void add(String label) {
        this.add(new MenuItem(label));
    }

    public void addSeparator() {
        MenuItem item = new MenuItem("-");
        item.parent = this;
        this.items.add(item);
        ((MenuPeer)this.peer).addSeparator();
    }

    private void resetPeer() {
        try {
            while (true) {
                ((MenuPeer)this.peer).delItem(0);
            }
        }
        catch (Exception e) {
            for (int i = 0; i < this.items.size(); ++i) {
                ((MenuPeer)this.peer).addItem((MenuItem)this.items.elementAt(i));
            }
            return;
        }
    }

    public synchronized void insert(MenuItem item, int position) {
        item.parent = this;
        this.items.insertElementAt(item, position);
        this.resetPeer();
    }

    public void insert(String label, int position) {
        this.insert(new MenuItem(label), position);
        this.resetPeer();
    }

    public void insertSeparator(int position) {
        this.insert(new MenuItem("-"), position);
        this.resetPeer();
    }

    public MenuItem getItem(int position) {
        return (MenuItem)this.items.get(position);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public synchronized void remove(int position) {
        this.items.remove(position);
        ((MenuPeer)this.peer).delItem(position);
    }

    public synchronized void remove(MenuComponent item) {
        int pos = this.items.indexOf(item);
        if (pos != -1) {
            this.remove(pos);
        }
    }

    public synchronized void removeAll() {
        for (int i = 0; i < this.items.size(); ++i) {
            ((MenuPeer)this.peer).delItem(0);
        }
        this.items.removeAllElements();
    }

    public boolean isTearOff() {
        return this.tearOff;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = Toolkit.getDefaultToolkit().createMenu(this);
        }
    }

    public void removeNotify() {
        super.removeNotify();
    }

    public String paramString() {
        return "java.awt.Menu";
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
    }

    private void writeObject(ObjectOutputStream s) throws ClassNotFoundException, IOException {
    }
}

