/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayoutInfo;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;

public class GridBagLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = 8838754796412211005L;
    public int[] columnWidths;
    public int[] rowHeights;
    public double[] columnWeights;
    public double[] rowWeights;
    protected Hashtable comptable = new Hashtable();
    protected GridBagConstraints defaultConstraints = new GridBagConstraints();
    protected GridBagLayoutInfo layoutInfo = null;
    protected static final int MAXGRIDSIZE = 512;
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;
    private transient int rows = 0;
    private transient int cols = 0;

    private void writeObject(ObjectOutputStream os) throws IOException {
        GridBagLayoutInfo info = this.layoutInfo;
        this.layoutInfo = null;
        os.defaultWriteObject();
        this.layoutInfo = info;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints != null) {
            if (constraints instanceof GridBagConstraints) {
                this.setConstraints(comp, (GridBagConstraints)constraints);
            } else {
                throw new IllegalArgumentException("illegal parameter type");
            }
        }
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public GridBagConstraints getConstraints(Component component) {
        return (GridBagConstraints)this.lookupConstraints(component).clone();
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public int[][] getLayoutDimensions() {
        if (this.layoutInfo == null) {
            return new int[2][0];
        }
        int[] widths = this.layoutInfo.columnWidths;
        int[] heights = this.layoutInfo.rowHeights;
        int[][] dimensions = new int[][]{new int[widths.length], new int[heights.length]};
        for (int i = 0; i < widths.length; ++i) {
            dimensions[0][i] = widths[i];
        }
        for (int j = 0; j < heights.length; ++j) {
            dimensions[1][j] = heights[j];
        }
        return dimensions;
    }

    public Point getLayoutOrigin() {
        if (this.layoutInfo == null) {
            return new Point(0, 0);
        }
        return new Point(this.layoutInfo.xLeft, this.layoutInfo.yTop);
    }

    public double[][] getLayoutWeights() {
        if (this.layoutInfo == null) {
            return new double[2][0];
        }
        double[] xWeights = this.layoutInfo.columnWeights;
        double[] yWeights = this.layoutInfo.rowWeights;
        double[][] weights = new double[][]{new double[xWeights.length], new double[yWeights.length]};
        for (int i = 0; i < xWeights.length; ++i) {
            weights[0][i] = xWeights[i];
        }
        for (int j = 0; j < yWeights.length; ++j) {
            weights[1][j] = yWeights[j];
        }
        return weights;
    }

    public void invalidateLayout(Container target) {
    }

    public void layoutContainer(Container container) {
        this.arrangeGrid(container);
    }

    public Point location(int x, int y) {
        int j;
        int i;
        if (this.layoutInfo == null) {
            return new Point(0, 0);
        }
        int k = this.layoutInfo.xLeft;
        for (i = 0; i < this.layoutInfo.ncols && x >= k; k += this.layoutInfo.columnWidths[i], ++i) {
        }
        int l = this.layoutInfo.yTop;
        for (j = 0; j < this.layoutInfo.nrows && y >= l; l += this.layoutInfo.rowHeights[j], ++j) {
        }
        return new Point(i, j);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension minimumLayoutSize(Container container) {
        if (container == null) {
            return new Dimension(0, 0);
        }
        GridBagLayoutInfo info = this.getLayoutInfo(container, 1);
        return this.getMinSize(container, info);
    }

    public Dimension preferredLayoutSize(Container container) {
        if (container == null) {
            return new Dimension(0, 0);
        }
        GridBagLayoutInfo info = this.getLayoutInfo(container, 2);
        return this.getMinSize(container, info);
    }

    public void removeLayoutComponent(Component comp) {
    }

    public void setConstraints(Component comp, GridBagConstraints constraints) {
        if (constraints == null) {
            throw new NullPointerException();
        }
        GridBagConstraints cclone = (GridBagConstraints)constraints.clone();
        int x = cclone.gridx;
        int y = cclone.gridy;
        if (x < 0) {
            x = -1;
        }
        if (y < 0) {
            y = -1;
        }
        int w = cclone.gridwidth;
        int h = cclone.gridheight;
        if (w == 0) {
            w = 0;
        }
        if (w < 0 && w != 0 && w != -1) {
            w = 1;
        }
        if (h == 0) {
            h = 0;
        }
        if (h < 0 && h != 0 && h != -1) {
            h = 1;
        }
        cclone.gridx = x;
        cclone.gridy = y;
        cclone.gridwidth = w;
        cclone.gridheight = h;
        this.comptable.put(comp, cclone);
    }

    public String toString() {
        return this.getClass().getName() + "[columnWidths = " + this.columnWidths + ", rowHeights = " + this.rowHeights + ", columnWeights = " + this.columnWeights + ", rowWeights = " + this.rowWeights + "]";
    }

    protected void adjustForGravity(GridBagConstraints constraints, Rectangle displayArea) {
        Dimension compSize = constraints.compSize;
        displayArea.x += constraints.insets.left;
        displayArea.width -= constraints.insets.left + constraints.insets.right;
        displayArea.y += constraints.insets.top;
        displayArea.height -= constraints.insets.top + constraints.insets.bottom;
        int restWidth = displayArea.width - compSize.width - constraints.ipadx;
        if (restWidth > 0 && constraints.fill != 2 && constraints.fill != 1) {
            displayArea.width = compSize.width + constraints.ipadx;
        } else {
            restWidth = 0;
        }
        int restHeight = displayArea.height - compSize.height - constraints.ipady;
        if (restHeight > 0 && constraints.fill != 3 && constraints.fill != 1) {
            displayArea.height = compSize.height + constraints.ipady;
        } else {
            restHeight = 0;
        }
        switch (constraints.anchor) {
            case 10: {
                displayArea.x += restWidth / 2;
                displayArea.y += restHeight / 2;
                break;
            }
            case 11: {
                displayArea.x += restWidth / 2;
                break;
            }
            case 12: {
                displayArea.x += restWidth;
                break;
            }
            case 13: {
                displayArea.x += restWidth;
                displayArea.y += restHeight / 2;
                break;
            }
            case 14: {
                displayArea.x += restWidth;
                displayArea.y += restHeight;
                break;
            }
            case 15: {
                displayArea.x += restWidth / 2;
                displayArea.y += restHeight;
                break;
            }
            case 16: {
                displayArea.y += restHeight;
                break;
            }
            case 17: {
                displayArea.y += restHeight / 2;
                break;
            }
            case 18: {
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal anchor value");
            }
        }
    }

    protected void arrangeGrid(Container container) {
        int extraHeight;
        double dz;
        int i;
        double totalWeight;
        int extraWidth;
        Component[] components = container.getComponents();
        Rectangle bounds = new Rectangle();
        Insets containerInsets = container.getInsets();
        if (!(components.length != 0 || this.columnWidths != null && this.columnWidths.length != 0 || this.rowHeights != null && this.rowHeights.length != 0)) {
            return;
        }
        GridBagLayoutInfo info = this.getLayoutInfo(container, 2);
        if (info.ncols == 0 && info.nrows == 0) {
            return;
        }
        this.layoutInfo = info;
        Dimension infoDim = this.getMinSize(container, info);
        int restWidth = extraWidth = container.width - infoDim.width;
        if (extraWidth != 0) {
            totalWeight = 0.0;
            for (i = 0; i < info.ncols; ++i) {
                totalWeight += info.columnWeights[i];
            }
            if (totalWeight > 0.0) {
                dz = 0.0;
                for (i = 0; i < info.ncols; ++i) {
                    if (!(info.columnWeights[i] > 0.0)) continue;
                    dz = (double)extraWidth * info.columnWeights[i] / totalWeight + dz;
                    int deltaWidth = (int)dz;
                    dz -= (double)deltaWidth;
                    if (info.columnWidths[i] + deltaWidth < 0) {
                        restWidth += info.columnWidths[i] + deltaWidth;
                        info.columnWidths[i] = 0;
                        continue;
                    }
                    restWidth -= deltaWidth;
                    int n = i;
                    info.columnWidths[n] = info.columnWidths[n] + deltaWidth;
                }
                info.columnWidths[0] = info.columnWidths[0] + restWidth / 2;
                int n = info.ncols - 1;
                info.columnWidths[n] = info.columnWidths[n] + (restWidth - restWidth / 2);
                restWidth = 0;
            }
        }
        int restHeight = extraHeight = container.height - infoDim.height;
        if (extraHeight != 0) {
            totalWeight = 0.0;
            for (i = 0; i < info.nrows; ++i) {
                totalWeight += info.rowWeights[i];
            }
            if (totalWeight > 0.0) {
                dz = 0.0;
                for (i = 0; i < info.nrows; ++i) {
                    if (!(info.rowWeights[i] > 0.0)) continue;
                    dz = (double)extraHeight * info.rowWeights[i] / totalWeight + dz;
                    int deltaHeight = (int)dz;
                    dz -= (double)deltaHeight;
                    if (info.rowHeights[i] + deltaHeight < 0) {
                        restHeight += info.rowHeights[i] + deltaHeight;
                        info.rowHeights[i] = 0;
                        continue;
                    }
                    restHeight -= deltaHeight;
                    int n = i;
                    info.rowHeights[n] = info.rowHeights[n] + deltaHeight;
                }
                info.rowHeights[0] = info.rowHeights[0] + restHeight / 2;
                int n = info.nrows - 1;
                info.rowHeights[n] = info.rowHeights[n] + (restHeight - restHeight / 2);
                restHeight = 0;
            }
        }
        info.xLeft = containerInsets.left + restWidth / 2;
        info.yTop = containerInsets.top + restHeight / 2;
        for (i = 0; i < components.length; ++i) {
            int l;
            int k;
            Component component = components[i];
            if (!component.isVisible()) continue;
            GridBagConstraints constraints = this.lookupConstraints(component);
            Rectangle displayArea = constraints.displayArea;
            int first = displayArea.x;
            int last = displayArea.x + displayArea.width;
            bounds.x = info.xLeft;
            for (k = 0; k < first; ++k) {
                bounds.x += info.columnWidths[k];
            }
            bounds.width = 0;
            for (k = first; k < last; ++k) {
                bounds.width += info.columnWidths[k];
            }
            first = displayArea.y;
            last = displayArea.y + displayArea.height;
            bounds.y = info.yTop;
            for (l = 0; l < first; ++l) {
                bounds.y += info.rowHeights[l];
            }
            bounds.height = 0;
            for (l = first; l < last; ++l) {
                bounds.height += info.rowHeights[l];
            }
            this.adjustForGravity(constraints, bounds);
            if (bounds.width > 0 && bounds.height > 0) {
                component.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
                continue;
            }
            component.setBounds(0, 0, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GridBagLayoutInfo getLayoutInfo(Container container, int sizeflag) {
        if (sizeflag != 1 && sizeflag != 2) {
            throw new IllegalArgumentException("illegal parameter value");
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            int compHeight;
            int compWidth;
            Dimension compSize;
            int row;
            int col;
            double spanWeight;
            Rectangle displayArea;
            int lastx;
            int j;
            int firstx;
            int lasty;
            int firsty;
            int gridheight;
            int gridwidth;
            int gridy;
            int gridx;
            int i;
            int ncols = 0;
            int nrows = 0;
            GridBagConstraints constr = null;
            Component[] components = container.getComponents();
            int[] maxColInRow = new int[512];
            int[] maxRowInCol = new int[512];
            int x = 0;
            int y = 0;
            boolean incrementColumn = true;
            for (i = 0; i < components.length; ++i) {
                if (!components[i].isVisible()) continue;
                constr = this.lookupConstraints(components[i]);
                gridx = constr.gridx;
                gridy = constr.gridy;
                gridwidth = constr.gridwidth;
                gridheight = constr.gridheight;
                if (gridwidth == 0 || gridwidth == -1) {
                    gridwidth = 1;
                }
                if (gridheight == 0 || gridheight == -1) {
                    gridheight = 1;
                }
                if (gridx == -1 && gridy == -1) {
                    if (incrementColumn) {
                        firsty = y;
                        lasty = firsty + gridheight;
                        firstx = 0;
                        for (j = firsty; j < lasty; ++j) {
                            if (maxColInRow[j] <= firstx) continue;
                            firstx = maxColInRow[j];
                        }
                    } else {
                        firstx = x;
                        lastx = firstx + gridwidth;
                        firsty = 0;
                        for (j = firstx; j < lastx; ++j) {
                            if (maxRowInCol[j] <= firsty) continue;
                            firsty = maxRowInCol[j];
                        }
                    }
                } else if (gridx == -1) {
                    firsty = gridy;
                    lasty = firsty + gridheight;
                    firstx = 0;
                    for (j = firsty; j < lasty; ++j) {
                        if (maxColInRow[j] <= firstx) continue;
                        firstx = maxColInRow[j];
                    }
                } else if (gridy == -1) {
                    firstx = gridx;
                    lastx = firstx + gridwidth;
                    firsty = 0;
                    for (j = firstx; j < lastx; ++j) {
                        if (maxRowInCol[j] <= firsty) continue;
                        firsty = maxRowInCol[j];
                    }
                } else {
                    firstx = gridx;
                    firsty = gridy;
                }
                lastx = firstx + gridwidth;
                lasty = firsty + gridheight;
                if (lastx > ncols) {
                    ncols = lastx;
                }
                if (lasty > nrows) {
                    nrows = lasty;
                }
                for (j = firsty; j < lasty; ++j) {
                    if (lastx <= maxColInRow[j]) continue;
                    maxColInRow[j] = lastx;
                }
                for (j = firstx; j < lastx; ++j) {
                    if (lasty <= maxRowInCol[j]) continue;
                    maxRowInCol[j] = lasty;
                }
                if (constr.gridwidth == 0 && constr.gridheight == 0) {
                    x = 0;
                    y = 0;
                    incrementColumn = true;
                    continue;
                }
                if (constr.gridwidth == 0) {
                    x = 0;
                    y = lasty;
                    incrementColumn = true;
                    continue;
                }
                if (constr.gridheight == 0) {
                    x = lastx;
                    y = 0;
                    incrementColumn = false;
                    continue;
                }
                if (incrementColumn) {
                    x = lastx;
                    continue;
                }
                y = lasty;
            }
            if (this.columnWidths != null && this.columnWidths.length > ncols) {
                ncols = this.columnWidths.length;
            }
            if (this.rowHeights != null && this.rowHeights.length > nrows) {
                nrows = this.rowHeights.length;
            }
            GridBagLayoutInfo info = new GridBagLayoutInfo(ncols, nrows);
            incrementColumn = true;
            y = 0;
            x = 0;
            maxColInRow = new int[512];
            maxRowInCol = new int[512];
            for (i = 0; i < components.length; ++i) {
                if (!components[i].isVisible()) continue;
                constr = this.lookupConstraints(components[i]);
                gridx = constr.gridx;
                gridy = constr.gridy;
                gridwidth = constr.gridwidth;
                gridheight = constr.gridheight;
                lastx = gridwidth == -1 ? ncols - 1 : (gridwidth == 0 ? ncols : 0);
                lasty = gridheight == -1 ? nrows - 1 : (gridheight == 0 ? nrows : 0);
                if (gridx == -1 && gridy == -1) {
                    if (incrementColumn) {
                        firsty = y;
                        if (gridheight != -1 && gridheight != 0) {
                            lasty = firsty + gridheight;
                        }
                        firstx = 0;
                        for (j = firsty; j < lasty; ++j) {
                            if (maxColInRow[j] <= firstx) continue;
                            firstx = maxColInRow[j];
                        }
                    } else {
                        firstx = x;
                        if (gridwidth != -1 && gridwidth != 0) {
                            lastx = firstx + gridwidth;
                        }
                        firsty = 0;
                        for (j = firstx; j < lastx; ++j) {
                            if (maxRowInCol[j] <= firsty) continue;
                            firsty = maxRowInCol[j];
                        }
                    }
                } else if (gridx == -1) {
                    firsty = gridy;
                    if (gridheight != -1 && gridheight != 0) {
                        lasty = firsty + gridheight;
                    }
                    firstx = 0;
                    for (j = firsty; j < lasty; ++j) {
                        if (maxColInRow[j] <= firstx) continue;
                        firstx = maxColInRow[j];
                    }
                } else if (gridy == -1) {
                    firstx = gridx;
                    if (gridwidth != -1 && gridwidth != 0) {
                        lastx = firstx + gridwidth;
                    }
                    firsty = 0;
                    for (j = firstx; j < lastx; ++j) {
                        if (maxRowInCol[j] <= firsty) continue;
                        firsty = maxRowInCol[j];
                    }
                } else {
                    firstx = gridx;
                    firsty = gridy;
                }
                if (gridwidth == -1 || gridwidth == 0) {
                    gridwidth = lastx - firstx;
                }
                if (gridheight == -1 || gridheight == 0) {
                    gridheight = lasty - firsty;
                }
                constr.displayArea = new Rectangle(firstx, firsty, gridwidth, gridheight);
                constr.compSize = sizeflag == 2 ? components[i].getPreferredSize() : components[i].getMinimumSize();
                lastx = firstx + gridwidth;
                lasty = firsty + gridheight;
                for (j = firsty; j < lasty; ++j) {
                    if (lastx <= maxColInRow[j]) continue;
                    maxColInRow[j] = lastx;
                }
                for (j = firstx; j < lastx; ++j) {
                    if (lasty <= maxRowInCol[j]) continue;
                    maxRowInCol[j] = lasty;
                }
                if (constr.gridwidth == 0 && constr.gridheight == 0) {
                    y = 0;
                    x = 0;
                    incrementColumn = true;
                    continue;
                }
                if (constr.gridwidth == 0) {
                    x = 0;
                    y = lasty;
                    incrementColumn = true;
                    continue;
                }
                if (constr.gridheight == 0) {
                    x = lastx;
                    y = 0;
                    incrementColumn = false;
                    continue;
                }
                if (incrementColumn) {
                    x = lastx;
                    continue;
                }
                y = lasty;
            }
            for (i = 0; i < components.length; ++i) {
                if (!components[i].isVisible()) continue;
                constr = this.lookupConstraints(components[i]);
                displayArea = constr.displayArea;
                if (displayArea.width == 1 && constr.weightx > info.columnWeights[displayArea.x]) {
                    info.columnWeights[displayArea.x] = constr.weightx;
                }
                if (displayArea.height != 1 || !(constr.weighty > info.rowWeights[displayArea.y])) continue;
                info.rowWeights[displayArea.y] = constr.weighty;
            }
            for (i = 0; i < components.length; ++i) {
                double deltaWeight;
                double restWeight;
                double extraWeight;
                if (!components[i].isVisible()) continue;
                constr = this.lookupConstraints(components[i]);
                displayArea = constr.displayArea;
                if (displayArea.width > 1) {
                    firstx = displayArea.x;
                    lastx = displayArea.x + displayArea.width;
                    spanWeight = 0.0;
                    for (col = firstx; col < lastx; ++col) {
                        spanWeight += info.columnWeights[col];
                    }
                    extraWeight = constr.weightx - spanWeight;
                    if (extraWeight > 0.0) {
                        restWeight = extraWeight;
                        if (spanWeight > 0.0) {
                            for (col = firstx; col < lastx; ++col) {
                                if (!(info.columnWeights[col] > 0.0)) continue;
                                deltaWeight = extraWeight * info.columnWeights[col] / spanWeight;
                                int n = col;
                                info.columnWeights[n] = info.columnWeights[n] + deltaWeight;
                                restWeight -= deltaWeight;
                            }
                        }
                        int n = lastx - 1;
                        info.columnWeights[n] = info.columnWeights[n] + restWeight;
                    }
                }
                if (displayArea.height <= 1) continue;
                firsty = displayArea.y;
                lasty = displayArea.y + displayArea.height;
                spanWeight = 0.0;
                for (row = firsty; row < lasty; ++row) {
                    spanWeight += info.rowWeights[row];
                }
                extraWeight = constr.weighty - spanWeight;
                if (!(extraWeight > 0.0)) continue;
                restWeight = extraWeight;
                if (spanWeight > 0.0) {
                    for (row = firsty; row < lasty; ++row) {
                        if (!(info.rowWeights[row] > 0.0)) continue;
                        deltaWeight = extraWeight * info.rowWeights[row] / spanWeight;
                        int n = row;
                        info.rowWeights[n] = info.rowWeights[n] + deltaWeight;
                        restWeight -= deltaWeight;
                    }
                }
                int n = lasty - 1;
                info.rowWeights[n] = info.rowWeights[n] + restWeight;
            }
            if (this.columnWeights != null) {
                lastx = this.columnWeights.length < info.columnWeights.length ? this.columnWeights.length : info.columnWeights.length;
                for (col = 0; col < lastx; ++col) {
                    if (!(this.columnWeights[col] > info.columnWeights[col])) continue;
                    info.columnWeights[col] = this.columnWeights[col];
                }
            }
            if (this.rowWeights != null) {
                lasty = this.rowWeights.length < info.rowWeights.length ? this.rowWeights.length : info.rowWeights.length;
                for (row = 0; row < lasty; ++row) {
                    if (!(this.rowWeights[row] > info.rowWeights[row])) continue;
                    info.rowWeights[row] = this.rowWeights[row];
                }
            }
            for (i = 0; i < components.length; ++i) {
                if (!components[i].isVisible()) continue;
                constr = this.lookupConstraints(components[i]);
                displayArea = constr.displayArea;
                compSize = constr.compSize;
                if (displayArea.width == 1 && (compWidth = compSize.width + constr.insets.left + constr.insets.right + constr.ipadx) > info.columnWidths[displayArea.x]) {
                    info.columnWidths[displayArea.x] = compWidth;
                }
                if (displayArea.height != 1 || (compHeight = compSize.height + constr.insets.top + constr.insets.bottom + constr.ipady) <= info.rowHeights[displayArea.y]) continue;
                info.rowHeights[displayArea.y] = compHeight;
            }
            for (i = 0; i < components.length; ++i) {
                if (!components[i].isVisible()) continue;
                constr = this.lookupConstraints(components[i]);
                displayArea = constr.displayArea;
                compSize = constr.compSize;
                if (displayArea.width > 1) {
                    compWidth = compSize.width + constr.insets.left + constr.insets.right + constr.ipadx;
                    firstx = displayArea.x;
                    lastx = displayArea.x + displayArea.width;
                    int spanWidth = 0;
                    for (col = firstx; col < lastx; ++col) {
                        spanWidth += info.columnWidths[col];
                    }
                    int extraWidth = compWidth - spanWidth;
                    if (extraWidth > 0) {
                        spanWeight = 0.0;
                        for (col = firstx; col < lastx; ++col) {
                            spanWeight += info.columnWeights[col];
                        }
                        int restWidth = extraWidth;
                        if (spanWeight > 0.0) {
                            for (col = firstx; col < lastx; ++col) {
                                if (!(info.columnWeights[col] > 0.0)) continue;
                                int deltaWidth = (int)((double)extraWidth * info.columnWeights[col] / spanWeight);
                                int n = col;
                                info.columnWidths[n] = info.columnWidths[n] + deltaWidth;
                                restWidth -= deltaWidth;
                            }
                        }
                        int n = lastx - 1;
                        info.columnWidths[n] = info.columnWidths[n] + restWidth;
                    }
                }
                if (displayArea.height <= 1) continue;
                compHeight = compSize.height + constr.insets.top + constr.insets.bottom + constr.ipady;
                firsty = displayArea.y;
                lasty = displayArea.y + displayArea.height;
                int spanHeight = 0;
                for (row = firsty; row < lasty; ++row) {
                    spanHeight += info.rowHeights[row];
                }
                int extraHeight = compHeight - spanHeight;
                if (extraHeight <= 0) continue;
                spanWeight = 0.0;
                for (row = firsty; row < lasty; ++row) {
                    spanWeight += info.rowWeights[row];
                }
                int restHeight = extraHeight;
                if (spanWeight > 0.0) {
                    for (row = firsty; row < lasty; ++row) {
                        if (!(info.rowWeights[row] > 0.0)) continue;
                        int deltaHeight = (int)((double)extraHeight * info.rowWeights[row] / spanWeight);
                        int n = row;
                        info.rowHeights[n] = info.rowHeights[n] + deltaHeight;
                        restHeight -= deltaHeight;
                    }
                }
                int n = lasty - 1;
                info.rowHeights[n] = info.rowHeights[n] + restHeight;
            }
            if (this.columnWidths != null) {
                lastx = this.columnWidths.length;
                for (col = 0; col < lastx; ++col) {
                    if (this.columnWidths[col] <= info.columnWidths[col]) continue;
                    info.columnWidths[col] = this.columnWidths[col];
                }
            }
            if (this.rowHeights != null) {
                lasty = this.rowHeights.length;
                for (row = 0; row < lasty; ++row) {
                    if (this.rowHeights[row] <= info.rowHeights[row]) continue;
                    info.rowHeights[row] = this.rowHeights[row];
                }
            }
            return info;
        }
    }

    protected Dimension getMinSize(Container container, GridBagLayoutInfo info) {
        if (container == null || info == null) {
            return new Dimension(0, 0);
        }
        Insets insets = container.getInsets();
        int w = 0;
        int h = 0;
        for (int i = 0; i < info.ncols; ++i) {
            w += info.columnWidths[i];
        }
        for (int j = 0; j < info.nrows; ++j) {
            h += info.rowHeights[j];
        }
        return new Dimension(insets.left + w + insets.right, insets.top + h + insets.bottom);
    }

    protected GridBagConstraints lookupConstraints(Component component) {
        GridBagConstraints c = (GridBagConstraints)this.comptable.get(component);
        if (c == null) {
            this.setConstraints(component, this.defaultConstraints);
            c = (GridBagConstraints)this.comptable.get(component);
        }
        return c;
    }
}

