/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;

public class Font
implements Serializable {
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    protected String name;
    protected int style;
    protected int size;
    private String family;

    private native void create(String var1, int var2, int var3);

    private static native void addFont(String var0, String var1);

    public Font(String name, int style, int size) {
        this.create(name, style, size);
    }

    public static Font decode(String spec) {
        int size;
        int style;
        String name;
        block14: {
            name = "";
            style = 0;
            size = 12;
            if (spec == null) {
                name = "dialog";
            } else if (spec.length() == 0) {
                name = "";
            } else {
                int DELIM = 45;
                int n = 0;
                n = spec.indexOf(DELIM);
                if (n != -1) {
                    name = spec.substring(0, n);
                    if (spec.length() > n + 1) {
                        int m = n + 1;
                        if ((n = spec.indexOf(DELIM, m)) == -1) {
                            n = spec.length();
                        }
                        if (n > m) {
                            String styleStr = spec.substring(m, n);
                            style = styleStr.equals("plain") ? 0 : (styleStr.equals("bold") ? 1 : (styleStr.equals("italic") ? 2 : (styleStr.equals("bolditalic") ? 3 : 0)));
                        }
                        if (spec.length() > n + 1) {
                            try {
                                int intV = Integer.parseInt(spec.substring(n + 1, spec.length()));
                                if (intV > 0) {
                                    size = intV;
                                    break block14;
                                }
                                size = 12;
                            }
                            catch (NumberFormatException e) {
                                size = 12;
                            }
                        }
                    } else {
                        style = 0;
                        size = 12;
                    }
                } else {
                    name = spec;
                    style = 0;
                    size = 12;
                }
            }
        }
        return new Font(name, style, size);
    }

    public boolean equals(Object object) {
        if (object instanceof Font) {
            Font fnt = (Font)object;
            return fnt.name.equals(this.name) && fnt.style == this.style && fnt.size == this.size;
        }
        return false;
    }

    public String getFamily() {
        return this.family;
    }

    public static Font getFont(String propName) {
        return Font.getFont(propName, null);
    }

    public static Font getFont(String propName, Font defaultFont) {
        String propValue = System.getProperty(propName);
        if (propValue != null) {
            return Font.decode(propValue);
        }
        return defaultFont;
    }

    public String getFontName() {
        System.out.println("[AWT warning] getFontName() not supported, use getName() instead");
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public int hashCode() {
        return new String(this.name + this.style + this.size).hashCode();
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public String toString() {
        String styleStr;
        switch (this.style) {
            case 0: {
                styleStr = "plain";
                break;
            }
            case 1: {
                styleStr = "bold";
                break;
            }
            case 2: {
                styleStr = "italic";
                break;
            }
            case 3: {
                styleStr = "bolditalic";
                break;
            }
            default: {
                styleStr = "plain";
            }
        }
        return this.getClass().getName() + "[family = " + this.family + ", name = " + this.name + ", style = " + styleStr + ", size = " + this.size + "]";
    }

    static {
        Properties fontProperties = new Properties();
        try {
            InputStream propstream = ClassLoader.getSystemResourceAsStream("font.properties");
            fontProperties.load(propstream);
        }
        catch (IOException e) {
            // empty catch block
        }
        String defaultFont = (String)fontProperties.get("default");
        if (defaultFont != null) {
            Font.addFont(defaultFont, (String)fontProperties.get(defaultFont));
            fontProperties.remove("default");
            fontProperties.remove(defaultFont);
        }
        Enumeration names = fontProperties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Font.addFont(name, (String)fontProperties.get(name));
        }
        Toolkit.getDefaultToolkit();
    }
}

