/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.io.Serializable;

public class Color
implements Serializable {
    private static final long serialVersionUID = 118526816881161077L;
    public static final Color lightGray = new Color(192, 192, 192);
    public static final Color gray = new Color(128, 128, 128);
    public static final Color darkGray = new Color(64, 64, 64);
    public static final Color black = new Color(0, 0, 0);
    public static final Color red = new Color(255, 0, 0);
    public static final Color pink = new Color(255, 175, 175);
    public static final Color orange = new Color(255, 200, 0);
    public static final Color yellow = new Color(255, 255, 0);
    public static final Color green = new Color(0, 255, 0);
    public static final Color magenta = new Color(255, 0, 255);
    public static final Color cyan = new Color(0, 255, 255);
    public static final Color blue = new Color(0, 0, 255);
    public static final Color white = new Color(255, 255, 255);
    private static final double FILTER = 0.7;
    int value;

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color(int r, int g, int b, int a) {
        this.value = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public Color(int rgb) {
        this.value = 0xFF000000 | rgb;
    }

    public Color(float r, float g, float b) {
        this((int)((double)(r * 255.0f) + 0.5), (int)((double)(g * 255.0f) + 0.5), (int)((double)(b * 255.0f) + 0.5));
    }

    public int getRed() {
        return this.getRGB() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRGB() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRGB() >> 0 & 0xFF;
    }

    public int getAlpha() {
        return this.getRGB() >> 24 & 0xFF;
    }

    public int getRGB() {
        return this.value;
    }

    public Color brighter() {
        int r = this.getRed();
        int g = this.getGreen();
        int b = this.getBlue();
        int i = 3;
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((double)r / 0.7), 255), Math.min((int)((double)g / 0.7), 255), Math.min((int)((double)b / 0.7), 255));
    }

    public Color darker() {
        return new Color(Math.max((int)((double)this.getRed() * 0.7), 0), Math.max((int)((double)this.getGreen() * 0.7), 0), Math.max((int)((double)this.getBlue() * 0.7), 0));
    }

    public static Color getColor(String propertyname) {
        String colorstr = System.getProperty(propertyname, null);
        if (colorstr != null) {
            return new Color(Integer.parseInt(colorstr));
        }
        return null;
    }

    public static Color getColor(String propertyname, Color defaultcolor) {
        String colorstr = System.getProperty(propertyname, null);
        if (colorstr != null) {
            return new Color(Integer.parseInt(colorstr));
        }
        return defaultcolor;
    }

    public static Color getColor(String propertyname, int defaultcolorint) {
        String colorstr = System.getProperty(propertyname, null);
        if (colorstr != null) {
            return new Color(Integer.parseInt(colorstr));
        }
        return new Color(defaultcolorint);
    }

    public static float[] RGBtoHSB(int r, int g, int b, float[] hsb) {
        float max;
        float r2 = (float)r / 255.0f;
        float g2 = (float)g / 255.0f;
        float b2 = (float)b / 255.0f;
        if (hsb == null) {
            hsb = new float[3];
        }
        float min = Math.min(Math.min(r2, g2), b2);
        float v = max = Math.max(Math.max(r2, g2), b2);
        float delta = max - min;
        if (max == 0.0f) {
            hsb[0] = 0.0f;
            hsb[1] = 0.0f;
            hsb[2] = 0.0f;
            return hsb;
        }
        float s = delta / max;
        float h = r2 == max ? (g2 - b2) / delta : (g2 == max ? 2.0f + (b2 - r2) / delta : 4.0f + (r2 - g2) / delta);
        if (h < 0.0f) {
            h += 6.0f;
        }
        hsb[0] = h /= 6.0f;
        hsb[1] = s;
        hsb[2] = v;
        return hsb;
    }

    public static int HSBtoRGB(float h, float s, float v) {
        float b;
        float g;
        float r;
        if (s == 0.0f) {
            float b2;
            float g2 = b2 = v;
            float r2 = b2;
            return 0xFF000000 | (int)(r2 * 255.0f) << 16 | (int)(g2 * 255.0f) << 8 | (int)(b2 * 255.0f);
        }
        int i = (int)Math.floor(h *= 6.0f);
        float f = h - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        switch (i) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            default: {
                r = v;
                g = p;
                b = q;
            }
        }
        return 0xFF000000 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }

    public static Color getHSBColor(float hue, float saturation, float brightness) {
        return new Color(Color.HSBtoRGB(hue, saturation, brightness));
    }

    public static Color decode(String nm) throws NumberFormatException {
        int idx = nm.indexOf(44);
        if (idx != -1) {
            int idx2 = nm.indexOf(44, idx + 1);
            if (idx2 == -1) {
                throw new NumberFormatException("String '" + nm + "' has the wrong number of commas to be a valid color");
            }
            int r = Integer.decode(nm.substring(0, idx));
            int g = Integer.decode(nm.substring(idx + 1, idx2));
            int b = Integer.decode(nm.substring(idx2 + 1));
            return new Color(r, g, b);
        }
        return new Color(Integer.decode(nm));
    }

    public boolean equals(Object object) {
        if (!(object instanceof Color)) {
            return false;
        }
        Color c = (Color)object;
        return this.getRed() == c.getRed() && this.getGreen() == c.getGreen() && this.getBlue() == c.getBlue();
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return this.getClass().getName() + "[r=" + this.getRed() + ",g=" + this.getGreen() + ",b=" + this.getBlue() + "]";
    }

    protected String paramString() {
        return this.getClass().getName() + "(" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + ",alfa " + this.getAlpha() + ")";
    }
}

