/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxMenuItemPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class CheckboxMenuItem
extends MenuItem
implements ItemSelectable {
    boolean state;
    int checkboxMenuItemSerializedDataVersion;
    transient ItemListener itemListener;

    public CheckboxMenuItem() {
        this(null);
    }

    public CheckboxMenuItem(String label) {
        this(label, false);
    }

    public CheckboxMenuItem(String label, boolean state) {
        super(label);
        this.state = state;
    }

    public boolean getState() {
        return this.state;
    }

    public synchronized void setState(boolean state) {
        this.state = state;
        ((CheckboxMenuItemPeer)this.peer).setState(state);
    }

    public Object[] getSelectedObjects() {
        if (this.state) {
            return new Object[]{this.getLabel()};
        }
        return null;
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, listener);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processItemEvent(ItemEvent event) {
        if (this.itemListener != null) {
            this.setState(event.getStateChange() == 1);
            this.itemListener.itemStateChanged(event);
        }
    }

    public synchronized void removeItemListener(ItemListener listener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, listener);
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = Toolkit.getDefaultToolkit().createCheckboxMenuItem(this);
        }
    }

    public String paramString() {
        return "java.awt.CheckboxMenuItem";
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
    }

    private void writeObject(ObjectOutputStream s) throws ClassNotFoundException, IOException {
    }
}

