/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxPeer;
import java.io.Serializable;

public class Checkbox
extends Component
implements Serializable,
ItemSelectable {
    String label;
    CheckboxGroup group;
    boolean state;
    ItemListener itemListener;
    private boolean isGroup;
    private CheckboxPeer peer;

    public Checkbox() {
        this("", false, null);
    }

    public Checkbox(String label) {
        this(label, false, null);
    }

    public Checkbox(String label, boolean state) {
        this(label, state, null);
    }

    public Checkbox(String label, CheckboxGroup group, boolean state) {
        this(label, state, group);
    }

    public Checkbox(String label, boolean state, CheckboxGroup group) {
        this.setLabel(label);
        this.setState(state);
        this.setCheckboxGroup(group);
        if (group != null && (state || group.getSelectedCheckbox() == null)) {
            group.setSelectedCheckbox(this);
        }
        this.addNotify();
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, listener);
    }

    public synchronized void removeItemListener(ItemListener listener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, listener);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processItemEvent(ItemEvent event) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(event);
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createCheckbox(this);
        }
        if (!this.notified) {
            super.addNotify();
        }
    }

    public void setCheckboxGroup(CheckboxGroup group) {
        if (group != null) {
            this.group = group;
            if (this.state) {
                group.setSelectedCheckbox(this);
            }
        } else {
            this.group = null;
        }
        this.peer.setCheckboxGroup(group);
    }

    public CheckboxGroup getCheckboxGroup() {
        return this.group;
    }

    public void setLabel(String label) {
        if (this.label != label) {
            this.label = label;
            this.valid = false;
            this.peer.setLabel(label);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setState(boolean state) {
        CheckboxGroup group = this.group;
        if (group != null) {
            if (!state) {
                if (group.getSelectedCheckbox() == this) {
                    state = true;
                }
            } else if (group.getSelectedCheckbox() != this) {
                group.setSelectedCheckbox(this);
            }
        }
        this.state = state;
        this.peer.setState(state);
    }

    public boolean getState() {
        return this.state;
    }

    public Object[] getSelectedObjects() {
        Object[] objects = this.state ? new Object[]{this.label} : null;
        return objects;
    }

    public String toString() {
        return this.getClass().getName() + " - label: " + this.label + ", bounds: x = " + this.x + ", y = " + this.y + ", w = " + this.width + ", h = " + this.height;
    }

    protected String paramString() {
        return this.getClass().getName() + " label: " + this.label + ", bounds:(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ") group:" + this.group;
    }
}

