/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Hashtable;

public class CardLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = -4328196481005934313L;
    int hgap;
    int vgap;
    Hashtable tab = new Hashtable();
    private transient Hashtable tableC2N = new Hashtable();

    public CardLayout() {
        this(0, 0);
    }

    public CardLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (!(constraints instanceof String)) {
            throw new IllegalArgumentException("non-string constraint");
        }
        this.addLayoutComponent((String)constraints, comp);
    }

    public void addLayoutComponent(String name, Component comp) {
        if (comp.getParent().getComponentCount() != 1) {
            comp.setVisible(false);
        } else {
            comp.setVisible(true);
        }
        this.tab.put(name, comp);
        this.tableC2N.put(comp, name);
    }

    public void first(Container parent) {
        Component fc = null;
        int cc = parent.getComponentCount();
        for (int i = 0; i < cc; ++i) {
            Component c = parent.getComponent(i);
            if (fc == null) {
                fc = c;
            }
            if (!c.isVisible()) continue;
            if (c != fc) {
                c.setVisible(false);
                fc.setVisible(true);
            }
            parent.validate();
            return;
        }
    }

    public int getHgap() {
        return this.hgap;
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    Dimension getLayoutSize(Container parent, boolean preferred) {
        Dimension d = new Dimension();
        int cc = parent.getComponentCount();
        for (int i = 0; i < cc; ++i) {
            Component c = parent.getComponent(i);
            Dimension cd = preferred ? c.getPreferredSize() : c.getMinimumSize();
            d.width = Math.max(d.width, cd.width);
            d.height = Math.max(d.height, cd.height);
        }
        Insets in = parent.getInsets();
        d.width += in.left + in.right;
        d.height += in.top + in.bottom;
        return d;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void invalidateLayout(Container parent) {
    }

    public void last(Container parent) {
        Component lc = null;
        int cc = parent.getComponentCount();
        for (int i = cc - 1; i >= 0; --i) {
            Component c = parent.getComponent(i);
            if (lc == null) {
                lc = c;
            }
            if (!c.isVisible()) continue;
            if (c != lc) {
                c.setVisible(false);
                lc.setVisible(true);
            }
            parent.validate();
            return;
        }
    }

    public void layoutContainer(Container parent) {
        Insets in = parent.getInsets();
        int cc = parent.getComponentCount();
        for (int i = 0; i < cc; ++i) {
            parent.getComponent(i).setBounds(in.left + this.hgap, in.top + this.vgap, parent.width - 2 * this.hgap - in.left - in.right, parent.height - 2 * this.vgap - in.top - in.bottom);
        }
    }

    public Dimension maximumLayoutSize(Container parent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, false);
    }

    public void next(Container parent) {
        Component lc = null;
        int cc = parent.getComponentCount();
        for (int i = 0; i < cc; ++i) {
            Component c = parent.getComponent(i);
            if (c.isVisible()) {
                lc = c;
                continue;
            }
            if (lc == null) continue;
            lc.setVisible(false);
            c.setVisible(true);
            parent.validate();
            return;
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, true);
    }

    public void previous(Container parent) {
        Component lc = null;
        int cc = parent.getComponentCount();
        for (int i = cc - 1; i >= 0; --i) {
            Component c = parent.getComponent(i);
            if (c.isVisible()) {
                lc = c;
                continue;
            }
            if (lc == null) continue;
            lc.setVisible(false);
            c.setVisible(true);
            parent.validate();
            return;
        }
    }

    public void removeLayoutComponent(Component c) {
        String name = (String)this.tableC2N.get(c);
        if (name != null) {
            this.tab.remove(name);
        }
        this.tableC2N.remove(c);
        if (c.isVisible()) {
            this.previous(c.getParent());
        }
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void show(Container parent, String name) {
        if (name == null) {
            return;
        }
        Component nc = (Component)this.tab.get(name);
        if (nc == null) {
            return;
        }
        int cc = parent.getComponentCount();
        for (int i = 0; i < cc; ++i) {
            Component c = parent.getComponent(i);
            if (!c.isVisible()) continue;
            c.setVisible(false);
        }
        nc.setVisible(true);
        parent.validate();
    }

    public String toString() {
        return "CardLayout: hgap: " + this.hgap + ", vgap: " + this.vgap;
    }
}

