/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class BorderLayout
implements LayoutManager2,
Serializable {
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    int hgap;
    int vgap;
    Component north;
    Component west;
    Component east;
    Component south;
    Component center;

    public BorderLayout() {
        this(0, 0);
    }

    public BorderLayout(int hgap, int vgap) {
        if (hgap < 0) {
            hgap = 0;
        }
        if (vgap < 0) {
            vgap = 0;
        }
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        if (hgap < 0) {
            throw new IllegalArgumentException("invalid parameter");
        }
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        if (vgap < 0) {
            throw new IllegalArgumentException("invalid parameter");
        }
        this.vgap = vgap;
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension d;
        Insets insets = container.getInsets();
        int plw = 0;
        int plh = 0;
        if (this.east != null) {
            d = this.east.getPreferredSize();
            plw = plw + d.width + this.hgap;
            plh = Math.max(plh, d.height);
        }
        if (this.west != null) {
            d = this.west.getPreferredSize();
            plw = plw + d.width + this.hgap;
            plh = Math.max(plh, d.height);
        }
        if (this.center != null) {
            d = this.center.getPreferredSize();
            plw += d.width;
            plh = Math.max(plh, d.height);
        }
        if (this.north != null) {
            d = this.north.getPreferredSize();
            plw = Math.max(plw, d.width);
            plh = plh + d.height + this.vgap;
        }
        if (this.south != null) {
            d = this.south.getPreferredSize();
            plw = Math.max(plw, d.width);
            plh = plh + d.height + this.vgap;
        }
        plw = plw + insets.left + insets.right;
        plh = plh + insets.top + insets.bottom;
        return new Dimension(plw, plh);
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension d;
        Insets insets = container.getInsets();
        int plw = 0;
        int plh = 0;
        if (this.east != null) {
            d = this.east.getPreferredSize();
            plw = plw + d.width + this.hgap;
            plh = Math.max(plh, d.height);
        }
        if (this.west != null) {
            d = this.west.getPreferredSize();
            plw = plw + d.width + this.hgap;
            plh = Math.max(plh, d.height);
        }
        if (this.center != null) {
            d = this.center.getPreferredSize();
            plw += d.width;
            plh = Math.max(plh, d.height);
        }
        if (this.north != null) {
            d = this.north.getPreferredSize();
            plw = Math.max(plw, d.width);
            plh = plh + d.height + this.vgap;
        }
        if (this.south != null) {
            d = this.south.getPreferredSize();
            plw = Math.max(plw, d.width);
            plh = plh + d.height + this.vgap;
        }
        plw = plw + insets.left + insets.right;
        plh = plh + insets.top + insets.bottom;
        return new Dimension(plw, plh);
    }

    public void addLayoutComponent(Component component, Object constraints) {
        if (constraints == null) {
            this.addLayoutComponent((String)null, component);
        } else if (constraints instanceof String) {
            this.addLayoutComponent((String)constraints, component);
        } else {
            throw new IllegalArgumentException("cannot add component to BorderLayout: constraint must be a string (or null)");
        }
    }

    public void addLayoutComponent(String name, Component comp) {
        if (name == null) {
            name = CENTER;
        }
        if (CENTER.equals(name)) {
            this.center = comp;
        } else if (NORTH.equals(name)) {
            this.north = comp;
        } else if (EAST.equals(name)) {
            this.east = comp;
        } else if (SOUTH.equals(name)) {
            this.south = comp;
        } else if (WEST.equals(name)) {
            this.west = comp;
        } else {
            throw new IllegalArgumentException("cannot add component to BorderLayout: unknown constraint: " + name);
        }
    }

    public void removeLayoutComponent(Component comp) {
        if (comp == this.center) {
            this.center = null;
        } else if (comp == this.north) {
            this.north = null;
        } else if (comp == this.east) {
            this.east = null;
        } else if (comp == this.south) {
            this.south = null;
        } else if (comp == this.west) {
            this.west = null;
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        Insets in = container.getInsets();
        int rn = in.top;
        int rw = in.left;
        int re = container.width - in.right;
        int rs = container.height - in.bottom;
        int w = 0;
        int h = 0;
        boolean x = false;
        int y = 0;
        boolean wmax = false;
        int hmax = 0;
        if (this.north != null && this.north.isVisible()) {
            h = this.north.getPreferredSize().height;
            this.north.setBounds(rw, rn, re - rw, h);
            rn = rn + h + this.vgap;
        }
        if (this.south != null && this.south.isVisible()) {
            h = this.south.getPreferredSize().height;
            this.south.setBounds(rw, rs - h, re - rw, h);
            rs = rs - h - this.vgap;
        }
        if (this.east != null && this.east.isVisible()) {
            w = this.east.getPreferredSize().width;
            h = rs - rn;
            hmax = this.east.getMaximumSize().height;
            y = 0;
            if (h > hmax) {
                y = (h - hmax) / 2;
                h = hmax;
            }
            if (re - w > 10000) {
                System.out.println("OOPS : " + re + " " + w + " " + container.width + " " + container + " " + this.east);
            }
            this.east.setBounds(re - w, rn + y, w, h);
            re = re - w - this.hgap;
        }
        if (this.west != null && this.west.isVisible()) {
            w = this.west.getPreferredSize().width;
            h = rs - rn;
            hmax = this.west.getMaximumSize().height;
            y = 0;
            if (h > hmax) {
                y = (h - hmax) / 2;
                h = hmax;
            }
            this.west.setBounds(rw, rn + y, w, h);
            rw = rw + w + this.hgap;
        }
        if (this.center != null) {
            this.center.setBounds(rw, rn, re - rw, rs - rn);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap = " + this.hgap + ", vgap = " + this.vgap + "]";
    }
}

